/* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2017, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: XIAO Tong (email: xiaotong@mail.neu.edu.cn) 2018-04-24
*/

#include "../XTensor.h"
#include "Negate.h"
#include "Negate.cuh"

namespace nts { // namespace nts(NiuTrans.Tensor)

/*
    set every entry to its minus value
    >> a - the tensor we are processing
*/
void Negate(XTensor * a)
{
#ifdef USE_CUDA
    /* run it on GPUs */
    if (a->devID >= 0) {
        CudaNegate(a);
    return;
}
#endif

    CheckNTErrors((a->dataType == DEFAULT_DTYPE), "TODO!");
    DTYPE * d = (DTYPE*)a->data;
    for (int i = 0; i < a->unitNum; i++)
        d[i] = -d[i];
}
} // namespace nts(NiuTrans.Tensor)