/* NiuTrans.Tensor - an open-source tensor library
 * Copyright (C) 2017, Natural Language Processing Lab, Northestern University. 
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
* $Created by: XIAO Tong (email: xiaotong@mail.neu.edu.cn) 2018-04-24
*/

#include "ScaleAndShift.h"
#include "ReduceSum.h"
#include "ReduceMean.h"

namespace nts{ // namespace nts(NiuTrans.Tensor)

/* 
get the mean value along a dimension of the tensor. For a 1-dimensional data array a,
mean = (1/n) * sum_i input_i

>> input - the input tensor
>> output - the output tensor
>> dim - the dimension where the reduction is performed on
*/
void ReduceMean(XTensor * input, XTensor * output, int dim)
{
    CheckNTErrors((input->order > dim), "Illegal dimension specified!");

	int dimRDI = input->order - dim - 1;
    int num = input->dimSizeRDI[dimRDI];

    ReduceSum(input, output, dim);
    ScaleAndShift(output, (DTYPE)1/num, 0);
}


} // namespace nts(NiuTrans.Tensor)