/* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2017, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: LI Yinqiao (email: li.yin.qiao.2012@hotmail.com) 2018-04-30
*/

#include "../XTensor.h"
#include "../XDevice.h"
#include "../function/Loss.h"


namespace nts { // namespace nt(NiuTrans.Tensor)
/* case 1 */
bool TestLoss1()
{
    /* a tensor of size 10000 * 1 */
    int order = 2;
    int order_reduce = 1;
    int * dimSize = new int[order];
    dimSize[0] = 10000;
    dimSize[1] = 1;

    int unitNum = 1;
    for (int i = 0; i < order; i++)
        unitNum *= dimSize[i];

    /* CPU test */
    bool cpuTest = true;

    /* create tensors */
    XTensor * a = NewTensor(order, dimSize);
    XTensor * b = NewTensor(order, dimSize);

    /* initialize variables */
    DTYPE* a_data = (DTYPE*)a->data;
    for (int i = 0; i < unitNum; i++)
        *a_data++ = 1;
    DTYPE* b_data = (DTYPE*)b->data;
    for (int i = 0; i < unitNum; i++)
        *b_data++ = 1;
    DTYPE error = 0.0F;
    error = LossCompute(a, b, SQUAREDERROR, false, 1, 0, dimSize[0], 0);
    printf("%d", error);
    /* call reduce max function */
    //ReduceMax(a, reduce_a, 0);
    //ReduceMax(b, reduce_b, 1);

    //DTYPE* reduce_a_data = (DTYPE*)reduce_a->data;
    //for (int i = 0; i < unitNum_a; i++)
    //    printf("%f ", *reduce_a_data++);
    //printf("\n");
    //DTYPE* reduce_b_data = (DTYPE*)reduce_b->data;
    //for (int i = 0; i < unitNum_b; i++)
    //    printf("%f ", *reduce_b_data++);

    /* check results */
    cpuTest = true;

#ifdef USE_CUDA
    /* GPU test */
    bool gpuTest = true;

    /* create tensor */
    XTensor * aGPU = NewTensor(order, dimSize, X_FLOAT);
    XTensor * bGPU = NewTensor(order, dimSize, X_FLOAT);

    /* Initialize variables */
    DTYPE* aGPU_data = (DTYPE*)aGPU->data;
    for (int i = 0; i < unitNum; i++)
        *aGPU_data++ = 1;
    DTYPE* bGPU_data = (DTYPE*)bGPU->data;
    for (int i = 0; i < unitNum; i++)
        *bGPU_data++ = 1;
    error = LossCompute(a, b, SQUAREDERROR, false, 1, 0, dimSize[0], 0);
    printf("%d", error);

    /* call reduce max function */
    //ReduceMax(aGPU, reduce_aGPU, 0);
    //ReduceMax(bGPU, reduce_bGPU, 1);

    /* check results */
    gpuTest = true;

    /* destroy variables */
    delete aGPU, bGPU;
    delete[] dimSize;
    return cpuTest && gpuTest;
#else
    /* destroy variables */
    delete a;
    delete b;
    return cpuTest;
#endif // USE_CUDA
}

/* other cases */
/*
TODO!!
*/

/* test for Sum Function */
extern "C"
    bool TestLoss()
{
    XPRINT(0, stdout, "[TEST Loss]\n");
    bool returnFlag = true, caseFlag = true;

    /* case 1 test */
    caseFlag = TestLoss1();
    if (!caseFlag) {
        returnFlag = false;
        XPRINT(0, stdout, ">> case 1 failed!\n");
    }
    else
        XPRINT(0, stdout, ">> case 1 passed!\n");

    ///* other cases test */
    ///*
    //TODO!!
    //*/

    if (returnFlag) {
        XPRINT(0, stdout, ">> All Passed!\n");
    }
    else
        XPRINT(0, stdout, ">> Failed!\n");

    XPRINT(0, stdout, "\n");

    return returnFlag;
}

} // namespace nt(NiuTrans.Tensor)
