/* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2017, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: XIAO Tong (email: xiaotong@mail.neu.edu.cn) 2018-04-24
*/

#include "../XTensor.h"
#include "Concatenate.h"
#include "Merge.h"
#include "ConcatenateSolely.h"

namespace nts { // namespace nts(NiuTrans.Tensor)

/*
concatenate a list of tensors along a given dimension
Note that this is actually a wrapper that selects "ConcatenateSolely"
or "Merge" by means of the tensor shapes
>> smalls - a list of tensors for concatenation
>> big - the resulting tensor
>> dim - which dimension we perform the concatenation
*/
void Concatenate(XList * smalls, XTensor * big, int dim)
{
    bool uniform = true;
    for (int i = 1; i < smalls->count; i++) {
        XTensor * a = (XTensor*)smalls->GetItem(i - 1);
        XTensor * b = (XTensor*)smalls->GetItem(i);
        CheckNTErrors((a && b), "Empty input tensors!");
        if (!XTensor::IsIdentical(a, b))
            uniform = false;
    }

    if (uniform)
        Merge(smalls, big, dim);
    else
        ConcatenateSolely(smalls, big, dim);
}

/*
concatenate two tensors along a given dimension
*/
void Concatenate(XTensor * smallA, XTensor * smallB, XTensor * big, int dim)
{
    XList smalls(2);
    smalls.Add(smallA);
    smalls.Add(smallB);

    Concatenate(&smalls, big, dim);
}

} // namespace nts(NiuTrans.Tensor)