/* 
* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2018, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: XIAO Tong (email: xiaotong@mail.neu.edu.cn) 2018-05-08
*/

#ifndef __SETDATA_H__
#define __SETDATA_H__

#include "../XTensor.h"

namespace nts { // namespace nts(NiuTrans.Tensor)

/* generate data items with a fixed value p */
extern "C"
void SetDataFixed(XTensor * tensor, void * valuePointer);

/* generate data items with a fixed value p (in int) */
extern "C"
void SetDataFixedInt(XTensor * tensor, int p);

/* generate data items with a fixed value p (in float) */
extern "C"
void SetDataFixedFloat(XTensor * tensor, float p);

/* generate data items with a fixed value p (in double) */
extern "C"
void SetDataFixedDouble(XTensor * tensor, double p);

/* generate data items with a uniform distribution in [low,high] */
extern "C"
void SetDataRand(XTensor * tensor, DTYPE low, DTYPE high);

/* generate data items with a normal distribution with specified mean and standard deviation */
extern "C"
void SetDataRandN(XTensor * tensor, DTYPE mean, DTYPE standardDeviation);

} // namespace nts(NiuTrans.Tensor)

#endif // __SETDATA_H__