/* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2017, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: Xu Chen (email: hello_master1954@163.com) 2018-06-27
*/

#include "../XTensor.h"
#include "../XUtility.h"
#include "TCopyValues.h"

namespace nts { // namespace nts(NiuTrans.Tensor)
/* case 1 */
bool TestCopyValues1()
{
    /* a input tensor of size 2 * 4 */
    int inputOrder = 2;
    int * inputDimSize = new int[inputOrder];
    inputDimSize[0] = 2;
    inputDimSize[1] = 4;

    int inputUnitNum = 1;
    for (int i = 0; i < inputOrder; i++)
        inputUnitNum *= inputDimSize[i];

    DTYPE inputData[2][4] = { {0.0, 1.0, 2.0, 3.0},
                              {4.0, 5.0, 6.0, 7.0} };

    DTYPE scaleFactor = 2.0;
    DTYPE shiftFactor = 0.5;

    /* CPU test */
    bool cpuTest = true;

    /* create tensors */
    XTensor * input = NewTensor(inputOrder, inputDimSize);
    XTensor * output = NewTensor(inputOrder, inputDimSize);

    /* initialize variables */
    input->SetData(inputData, inputUnitNum);
    output->SetZeroAll();

    /* call CopyValues function */
    CopyValues(input, output);

    /* check results */
    cpuTest = output->CheckData(input->data, inputUnitNum);
#ifdef USE_CUDA
    /* GPU test */
    bool gpuTest = true;

    /* create tensors */
    XTensor * inputGPU = NewTensor(inputOrder, inputDimSize, X_FLOAT, 1.0F, 0);
    XTensor * outputGPU = NewTensor(inputOrder, inputDimSize, X_FLOAT, 1.0F, 0);

    /* initialize variables */
    inputGPU->SetData(inputData, inputUnitNum);
    outputGPU->SetData(inputData, inputUnitNum);

    /* call CopyValues function */
    CopyValues(inputGPU, outputGPU);

    /* check results */
    DTYPE * dataGPU = (DTYPE*)inputGPU->data;
    int size = inputUnitNum * inputGPU->unitSize;
    char * dataCPU = new char[size];
    XMemCopy(dataCPU, -1, dataGPU, inputGPU->devID, size);

    gpuTest = outputGPU->CheckData(dataCPU, inputUnitNum);

    /* destroy variables */
    delete input, output;
    delete inputGPU, outputGPU;
    delete[] inputDimSize;

    return cpuTest && gpuTest;
#else
    /* destroy variables */
    delete input, output;
    delete[] inputDimSize;

    return cpuTest;
#endif // USE_CUDA
}

/* other cases */
/*
TODO!!
*/

/* test for CopyValues Function */
extern "C"
bool TestCopyValues()
{
    XPRINT(0, stdout, "[TEST CopyValues]\n");
    bool returnFlag = true, caseFlag = true;

    /* case 1 test */
    caseFlag = TestCopyValues1();
    if (!caseFlag) {
        returnFlag = false;
        XPRINT(0, stdout, ">> case 1 failed!\n");
    }
    else
        XPRINT(0, stdout, ">> case 1 passed!\n");

    /* other cases test */
    /*
    TODO!!
    */

    if (returnFlag) {
        XPRINT(0, stdout, ">> All Passed!\n");
    }
    else
        XPRINT(0, stdout, ">> Failed!\n");

    XPRINT(0, stdout, "\n");

    return returnFlag;
    }

} // namespace nts(NiuTrans.Tensor)
