/* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2017, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: Xu Chen (email: hello_master1954@163.com) 2018-06-27
*/

#include "../XTensor.h"
#include "TReduceVariance.h"

namespace nts { // namespace nts(NiuTrans.Tensor)
/* case 1 */
bool TestReduceVariance1()
{
    /* a input tensor of size 2 * 4 */
    int inputOrder = 2;
    int * inputDimSize = new int[inputOrder];
    inputDimSize[0] = 2;
    inputDimSize[1] = 4;

    int inputUnitNum = 1;
    for (int i = 0; i < inputOrder; i++)
        inputUnitNum *= inputDimSize[i];

    /* a output tensor of size 1 */
    int outputOrder = 1;
    int * outputDimSize = new int[outputOrder];
    outputDimSize[0] = 4;

    int outputUnitNum = 1;
    for (int i = 0; i < outputOrder; i++)
        outputUnitNum *= outputDimSize[i];

    /* a shift tensor of size 1 */
    int meanOrder = 1;
    int * meanDimSize = new int[meanOrder];
    meanDimSize[0] = 4;

    int meanUnitNum = 1;
    for (int i = 0; i < meanOrder; i++)
        meanUnitNum *= meanDimSize[i];

    DTYPE inputData[2][4] = { {0.0, 1.0, 2.0, 3.0},
                              {4.0, 5.0, 6.0, 7.0} };
    DTYPE meanData[4] = {2.0, 3.0, 4.0, 5.0};
    DTYPE answer[4] = {4.0, 4.0, 4.0, 4.0};

    /* CPU test */
    bool cpuTest = true;

    /* create tensors */
    XTensor * input = NewTensor(inputOrder, inputDimSize);
    XTensor * output = NewTensor(outputOrder, outputDimSize);
    XTensor * mean = NewTensor(meanOrder, meanDimSize);

    /* initialize variables */
    input->SetData(inputData, inputUnitNum);
    mean->SetData(meanData, meanUnitNum);
    output->SetZeroAll();

    /* call ReduceVariance function */
    ReduceVariance(input, output, 0, mean);

    /* check results */
    cpuTest = output->CheckData(answer, outputUnitNum);

#ifdef USE_CUDA
    /* GPU test */
    bool gpuTest = true;

    /* create tensors */
    XTensor * inputGPU = NewTensor(inputOrder, inputDimSize, X_FLOAT, 1.0F, 0);
    XTensor * outputGPU = NewTensor(outputOrder, outputDimSize, X_FLOAT, 1.0F, 0);
    XTensor * meanGPU = NewTensor(meanOrder, meanDimSize, X_FLOAT, 1.0F, 0);

    /* initialize variables */
    inputGPU->SetData(inputData, inputUnitNum);
    meanGPU->SetData(meanData, meanUnitNum);
    outputGPU->SetZeroAll();

    /* call ReduceVariance function */
    ReduceVariance(inputGPU, outputGPU, 0, meanGPU);

    /* check results */
    gpuTest = output->CheckData(answer, outputUnitNum);

    /* destroy variables */
    delete input, output, mean;
    delete inputGPU, outputGPU, meanGPU;
    delete[] inputDimSize, outputDimSize, meanDimSize;

    return cpuTest && gpuTest;
#else
    /* destroy variables */
    delete input, output, mean;
    delete[] inputDimSize, outputDimSize, meanDimSize;


    return cpuTest;
#endif // USE_CUDA
}

/* other cases */
/*
TODO!!
*/

/* test for ReduceVariance Function */
extern "C"
bool TestReduceVariance()
{
    XPRINT(0, stdout, "[TEST ReduceVariance]\n");
    bool returnFlag = true, caseFlag = true;

    /* case 1 test */
    caseFlag = TestReduceVariance1();
    if (!caseFlag) {
        returnFlag = false;
        XPRINT(0, stdout, ">> case 1 failed!\n");
    }
    else
        XPRINT(0, stdout, ">> case 1 passed!\n");

    /* other cases test */
    /*
    TODO!!
    */

    if (returnFlag) {
        XPRINT(0, stdout, ">> All Passed!\n");
    }
    else
        XPRINT(0, stdout, ">> Failed!\n");

    XPRINT(0, stdout, "\n");

    return returnFlag;
    }

} // namespace nts(NiuTrans.Tensor)
