/* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2017, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: LI Yinqiao (li.yin.qiao.2012@hotmail.com) 2018-05-01
*/

#include "Test.h"

namespace nts { // namespace nts(NiuTrans.Tensor)

/* test for all Function */
bool Test()
{
    bool wrong = false;
    XPRINT(0, stdout, "Testing the XTensor utilites ... \n\n");

    wrong = !TestConcatenate() || wrong;
    wrong = !TestConcatenateSolely() || wrong;
    wrong = !TestMatrixMul() || wrong;
    wrong = !TestMatrixMul2D() || wrong;
    wrong = !TestMatrixMulBatchedCPU() || wrong;
    wrong = !TestMerge() || wrong;
    wrong = !TestMultiplyElementWise() || wrong;
    wrong = !TestNegate() || wrong;
    wrong = !TestNormalize() || wrong;
    wrong = !TestPower() || wrong;
    wrong = !TestReduceMax() || wrong;
    wrong = !TestReduceMean() || wrong;
    wrong = !TestReduceSum() || wrong;
    wrong = !TestSort() || wrong;
    wrong = !TestSplit() || wrong;
    wrong = !TestSum() || wrong;
    wrong = !TestXMem() || wrong;

    //wrong = !TestHardTanH() || wrong;
    //wrong = !TestLoss() || wrong;
    //wrong = !TestRectify() || wrong;
    wrong = !TestSigmoid() || wrong;
    //wrong = !TestSoftmax() || wrong;

    /* other test */
    /*
    TODO!!
    */

    if (wrong) {
        XPRINT(0, stdout, "Something goes wrong! Please check the code!\n");
        return false;
    }
    else {
        XPRINT(0, stdout, "OK! Everything is good!\n");
        return true;
    }
}

} // namespace nts(NiuTrans.Tensor)