#!/usr/bin/env bash

set -e

model_dir=$1
subset=$2
trans_file=${model_dir}/$3
data_dir=$4
tgt_lang=$5

txt_dir=$data_dir/data/$subset/txt/
sort -n -t $'\t' $trans_file | cut -f 4 > $model_dir/hyp

if [[ -f ${txt_dir}/${subset}.${tgt_lang}.0 ]]; then
    sacrebleu ${txt_dir}/${subset}.${tgt_lang}.0 ${txt_dir}/${subset}.${tgt_lang}.1 ${txt_dir}/${subset}.${tgt_lang}.2 ${txt_dir}/${subset}.${tgt_lang}.3 \
        -i $model_dir/hyp -m bleu -w 4
else 
    sacrebleu ${txt_dir}/${subset}.${tgt_lang} -i $model_dir/hyp -m bleu -w 4
fi
echo ""