#!/usr/bin/env bash

gpu_num=1

src_lang=es
tgt_lang=en

share_dict=1
lcrm=0
tokenizer=0

data_dir=
test_subset=(test test1 test2 test3 test4)

exp_name=
if [ "$#" -eq 1 ]; then
    exp_name=$1
fi

sacrebleu=1
n_average=10
beam_size=5
len_penalty=1.0
max_tokens=40000
dec_model=checkpoint_best.pt

cmd="./run.sh
    --stage 3
    --stop_stage 3
    --src_lang ${src_lang}
    --tgt_lang ${tgt_lang}
    --share_dict ${share_dict}
    --lcrm ${lcrm}
    --tokenizer ${tokenizer}
    --gpu_num ${gpu_num}
    --exp_name ${exp_name}
    --sacrebleu ${sacrebleu}
    --n_average ${n_average}
    --beam_size ${beam_size}
    --len_penalty ${len_penalty}
    --max_tokens ${max_tokens}
    --dec_model ${dec_model}
    "

if [[ -n ${data_dir} ]]; then
    cmd="$cmd --data_dir ${data_dir}"
fi
if [[ -n ${test_subset} ]]; then
    test_subset=`echo ${test_subset[*]} | sed 's/ /,/g'`
    cmd="$cmd --test_subset ${test_subset}"
fi

echo $cmd
eval $cmd
