/* NiuTrans.Tensor - an open-source tensor library
* Copyright (C) 2017, Natural Language Processing Lab, Northestern University.
* All rights reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*   http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/*
* $Created by: LI Yinqiao (li.yin.qiao.2012@hotmail.com) 2018-04-30
*/

#include "../XTensor.h"
#include "../XDevice.h"
#include "../core/Sort.h"

namespace nts { // namespace nts(NiuTrans.Tensor)
/* case 1 */
bool TestSort1()
{
    /* a tensor of size 2 * 4 */
    int order = 2;
    int * dimSize = new int[order];
    dimSize[0] = 2;
    dimSize[1] = 4;

    int unitNum = 1;
    for (int i = 0; i < order; i++)
        unitNum *= dimSize[i];

    DTYPE aData[2][4] = { { 0.0,   1.0,   2.0,   3.0 },
                          { 4.0,   5.0,   6.0,   7.0 } };
    DTYPE answer[2][4] = { { 4.0,   5.0,  6.0,  7.0 },
                           { 0.0,   1.0,  2.0,  3.0 } };

    /* CPU test */
    bool cpuTest = true;

    /* create tensors */
    XTensor * a = NewTensor(order, dimSize);
    XTensor * b = NewTensor(order, dimSize);
    b->dataType = X_INT;

    /* initialize variables */
    a->SetData(aData, unitNum);

    /* call sort function */
    Sort(a, b, 0);
    DTYPE* check1 = (DTYPE*)a->data;
    for (int i = 0; i < 8; i++)
        printf("%f ", *check1++);
    printf("\n");
    int* check2 = (int*)b->data;
    for (int i = 0; i < 8; i++)
        printf("%d ", *check2++);
    printf("\n");
    /* check results */
    cpuTest = a->CheckData(answer, unitNum);

#ifdef USE_CUDA
    /* GPU test */
    bool gpuTest = true;

    /* create tensor */
    XTensor * aGPU = NewTensor(order, dimSize, X_FLOAT);
    XTensor * bGPU = NewTensor(order, dimSize, X_FLOAT);
    bGPU->dataType = X_INT;
    /* Initialize variables */
    aGPU->SetData(aData, unitNum);

    /* call sum function */
    Sort(aGPU, bGPU, 0);

    /* check results */
    gpuTest = aGPU->CheckData(answer, unitNum);

    /* destroy variables */
    delete a, b, aGPU, bGPU;
    delete[] dimSize;
    return cpuTest && gpuTest;
#else
    /* destroy variables */
    delete a;
    delete b;
    delete[] dimSize;
    return cpuTest;
#endif // USE_CUDA
}

bool TestSort2()
{
    /* a tensor of size 2 * 4 */
    int order = 2;
    int * dimSize = new int[order];
    dimSize[0] = 2;
    dimSize[1] = 4;

    int unitNum = 1;
    for (int i = 0; i < order; i++)
        unitNum *= dimSize[i];

    DTYPE aData[2][4] = { { 0.0,   1.0,   2.0,   3.0 },
                          { 4.0,   5.0,   6.0,   7.0 } };
    DTYPE answer[2][4] = { { 3.0,   2.0,   1.0,   0.0 },
                           { 7.0,   6.0,   5.0,   4.0 } };

    /* CPU test */
    bool cpuTest = true;

    /* create tensors */
    XTensor * a = NewTensor(order, dimSize);
    XTensor * b = NewTensor(order, dimSize);
    b->dataType = X_INT;

    /* initialize variables */
    a->SetData(aData, unitNum);

    /* call sort function */
    Sort(a, b, 1);
    DTYPE* check1 = (DTYPE*)a->data;
    for (int i = 0; i < 8; i++)
        printf("%f ", *check1++);
    printf("\n");
    int* check2 = (int*)b->data;
    for (int i = 0; i < 8; i++)
        printf("%d ", *check2++);
    printf("\n");
    /* check results */
    cpuTest = a->CheckData(answer, unitNum);

#ifdef USE_CUDA
    /* GPU test */
    bool gpuTest = true;

    /* create tensor */
    XTensor * aGPU = NewTensor(order, dimSize, X_FLOAT);
    XTensor * bGPU = NewTensor(order, dimSize, X_FLOAT);
    bGPU->dataType = X_INT;
    /* Initialize variables */
    aGPU->SetData(aData, unitNum);

    /* call sum function */
    Sort(aGPU, bGPU, 1);

    /* check results */
    gpuTest = aGPU->CheckData(answer, unitNum);

    /* destroy variables */
    delete a, b, aGPU, bGPU;
    delete[] dimSize;
    return cpuTest && gpuTest;
#else
    /* destroy variables */
    delete a;
    delete b;
    delete[] dimSize;
    return cpuTest;
#endif // USE_CUDA
}
/* other cases */
/*
TODO!!
*/

/* test for Sum Function */
extern "C"
bool TestSort()
{
    XPRINT(0, stdout, "[TEST SORT]\n");
    bool returnFlag = true, caseFlag = true;

    /* case 1 test */
    caseFlag = TestSort1();
    if (!caseFlag) {
        returnFlag = false;
        XPRINT(0, stdout, ">> case 1 failed!\n");
    }
    else
        XPRINT(0, stdout, ">> case 1 passed!\n");

    /* case 2 test */
    caseFlag = TestSort2();
    if (!caseFlag) {
        returnFlag = false;
        XPRINT(0, stdout, ">> case 2 failed!\n");
    }
    else
        XPRINT(0, stdout, ">> case 2 passed!\n");
    /* other cases test */
    /*
    TODO!!
    */

    if (returnFlag) {
        XPRINT(0, stdout, ">> All Passed!\n");
    }
    else
        XPRINT(0, stdout, ">> Failed!\n");

    XPRINT(0, stdout, "\n");

    return returnFlag;
}

} // namespace nts(NiuTrans.Tensor)
