#! /usr/bin/bash
set -e

# device, you can set multiple devices, e.g. device=(0 1 2)
# then program will parallelly translate over various evalset (e.g. evalset=(cwmt18-dev mt06 mt08), or over various alpha (e.g. alphas=(1.0 1.1 1.2). 
# However, note that multiple evalset and multiple alpha can not set concurrently.
# more device will not be used. e.g. you set device=(0 1 2 3), but you only choose three evalset, the gpu=3 will not be used
device=(0 1 2 3 4 5 6 7)
# your model
#model=transformer_dla
model=transformer
# your hparams
#params=transformer_dla_base
params=transformer_base
# your tag, must set!
tag=base25

model_dir=t2tmodel/$tag/ensemble15

output_dir=checkpoints/$tag

if [ ! -d "$output_dir" ]; then
  mkdir -p $output_dir
fi

n_head=8
result=$(echo $params | sed -n '/base/'p)
                if [[ "$result" != "" ]]; then
                        n_head=8
                else
                        n_head=16
                fi
echo "n_head=$n_head"

CUDA_VISIBLE_DEVICES=7 python3 scripts/convert_t2t_new_to_fairseq.py -name $model -model $model_dir/ensemble_15-0 -src_vocab t2tmodel/source_dic -tgt_vocab t2tmodel/target_dic -head_num $n_head -vocab_output $model_dir/fairseq.vocab -model_output $output_dir/fairseq.pt

rm online.vocab
