#!/usr/bin/bash
set -e
device=$1
model_root_dir=checkpoints
# set tag
model_dir_tag=zh2en
model_dir=$model_root_dir/$model_dir_tag

ensemble=
checkpoint=fairseq.pt


if [ -n "$ensemble" ]; then
	if [ ! -e "$model_dir/last$ensemble.ensemble.pt" ]; then
		PYTHONPATH=`pwd` python3 scripts/average_checkpoints.py --inputs $model_dir --output $model_dir/last$ensemble.ensemble.pt --num-epoch-checkpoints $ensemble
	fi
	checkpoint=last$ensemble.ensemble.pt
fi

output=$model_dir/translation.log

CUDA_VISIBLE_DEVICES=$device nohup python3 -u generate.py \
data-bin/zh2en$device \
--path $model_dir/$checkpoint \
--batch-size 128 \
--beam 4 \
--lenpen 0.6 \
--gen-subset test \
--score-reference \
--skip-invalid-size-inputs-valid-test \
--score-file id_score$device.txt \
--remove-bpe > out$device &

#python3 parse_translation_log.py -i $output --tgt_lang de

#echo -e "\n>> BLEU-13a"
#cat ${output}.trans | sacrebleu -t wmt14/full -l en-de -tok 13a

#echo -e "\n>> BLEU-intl"
#cat ${output}.trans | sacrebleu -t wmt14/full -l en-de -tok intl 

