#encoding=utf-8
import os
import sys

def calBatchNum(srcfile, dstfile, batchsize):
    ret = True
    try:
        srcfd = open(srcfile,'r')
    except IOError:
        print ('srcfile does not exist!')
    try:
        dstfd = open(dstfile,'r')
    except IOError:
        print ('dstfile does not exist!')

    maxlist=[]
    with open(srcfile, encoding='utf-8') as srclines, open(dstfile) as dstlines:
        for srcline, dstline in zip(srclines, dstlines):
            srclinelist = srcline.split(' ')
            srclinenum = len(srclinelist)
            dstlinelist = dstline.split(' ')
            dstlinenum = len(dstlinelist)
            maxlist.append(max(srclinenum, dstlinenum))

    batchnum = 1
    batchroom = batchsize
    for i in range(0, len(maxlist)):
        batchroom = batchroom - maxlist[i]
        if batchroom < 0:
            batchnum = batchnum + 1
            batchroom = batchsize - maxlist[i]
            if batchroom < 0:
                print('can not make room for this sentence 0', i)
                return

    print('total batch number is', batchnum)

    srcfd.close()
    dstfd.close()
    return ret
if __name__ == "__main__":
    srcfile = ''
    dstfile = ''
    batchsizestr = ''
    batchsize = 0
    if len(sys.argv) == 4:
        srcfile = sys.argv[1]
        dstfile = sys.argv[2]
        batchsizestr = sys.argv[3]
        batchsize = int(batchsizestr)
    else:
        errorInfo = '****************** Error ******************\r\n'
        errorInfo = errorInfo + 'Please input with srcfile path, dstfile path and batchsize\r\n'
        errorInfo = errorInfo + 'e.g.:$ python ./calBatchNum.py srtfile dstfile batchsize\r\n'
        print (errorInfo)
        exit(1)
    calBatchNum(srcfile, dstfile, batchsize)
