#! /usr/bin/bash
set -e
##################################SET PARAMS#######################################
# eval目录, e.g. ../data/zh2en/v4-bpe32k-cwmt18/eval/
eval_dir=./eval/
# 源语端BPE词表路径, e.g. ../data/zh2en/v4-bpe32k-cwmt18/eval/src.bpe
src_bpe=./bpe0.5/zh.bpe
# 源语端命名关键字,规定测试集源语言端命名需带input.token, 对应bpe输出input.bpe
input=input.token
output=input.bpe
# python的版本
PYTHON=python
#apply_bpe程序路径
APPLY_BPE=./subword-nmt-master/apply_bpe.py
################################SET PARAMS#########################################

if [ ! -d "$eval_dir" ]; then
	echo "$eval_dir is not exists."
	exit 1
fi

echo "######## START RUN ########"
for file in $eval_dir/* ;do
{
	if [ -d $file ]; then
		flag1=1
		for sub_file in $file/*;do
		{
			if [ -f $sub_file ]; then
				if [[ $sub_file =~ $output ]]; then
					flag1=2
					echo " HAS EXISTS , PROCESS FILE FOLDER : $file "
					break
				fi
			fi	
		}
		done			
                if [ "$flag1" != "2"  ]; then
			flag2=3
			for sub_file in $file/*;do
			{
				if [ -f $sub_file ]; then
					if [[ $sub_file =~ $input ]]; then
                                        	sub_file_bpe=${sub_file/%"token"/"bpe"} 
                                        	#echo $sub_file_bpe
						cmd="$PYTHON $APPLY_BPE -c $src_bpe   -i $sub_file -o $sub_file_bpe"
                                        	$cmd
                                        	echo " CREATE SUCCESSFUL , PROCESS FILE FOLDER : $file "
						flag2=4
					fi
				fi
			}
			done
			if [ "$flag2" != "4" ]; then
				echo "WARNING: make sure source filename in the $file contains key, $key "

			fi

		fi
	fi
}
done
echo "######## END OF PROGRAM ########"
