/****************************************************************************
* Project Name : NiuTrans Server Decoder
* File Name    : basic_method.h
* Author       : Wang Qiang
* Email        : wangqiang@zjyatuo.com
* Create Time  : 2016/1/15 11:11:35
* Copyright    : Copyright (c) 2016 Shenyang YaTrans Network Technology Co., Ltd. All Rights Reserved.
*
* basic toolkit 
*
****************************************************************************/



#ifndef DECODER_BASIC_METHOD_H_
#define DECODER_BASIC_METHOD_H_

#include <iostream>
#include <string>
#include <vector>
#include <fstream>
#include <sstream>
#include <set>
#include <cstdio>
#include <cstdlib>
#include <cctype>
#include <ctime>
using namespace std;


namespace basic_method
{

	class SystemCommand
	{
	public:
		string sort_file_;
		string delete_command_;

	public:
		SystemCommand(string &newSortFile, string &newDel) : sort_file_(newSortFile), delete_command_(newDel) {}
	};


	class BasicMethod
	{
	public:
		typedef string::size_type STRPOS;

	public:
		bool Split(const string &phraseTable, const char &splitchar, vector< string > &dest);

	public:
		bool SplitWithStr(const string &src, const string &separator, vector< string > &dest);

	public:
		bool deleteFileList(vector< string > &fileList, SystemCommand &systemCommand);

	public:
		bool Replace_String(string & original , const string & source_str , const string & target_str);
		int	Get_Word_Count(string & input , char sep);
	

	public:
		string size_tToString(size_t &source);
		string intToString(int &source);
		string ConvertCharToString(char &input_char);

	public:
		bool ClearIllegalChar(string &str);

	public:
		bool toUpper(string &str);
		bool ToLower(string &str);

	public:
		bool RmEndSpace(string &str);
		bool RmStartSpace(string &str);

	public:
		bool RemoveExtraSpace(string &input_string, string &output_string);

	};

}

#endif

