/*
* $Id:
* 0002
*
* $File:
* main.cpp
*
* $Proj:
* RecaserLib for Statistical Machine Translation
*
* $Func:
* main function
*
* $Version:
* 0.0.1
*
* $Created by:
* Qiang Li
*
* $Email
* liqiangneu@gmail.com
*
* $Last Modified by:
* 2014-01-10,13:14
*/

#include "main.h"

int main( int argc, char * argv[] ) {
  if( argc < 4 ) {
    cerr<<"[USAGE] EXE CONFIG TEST OUTPUT\n"<<flush;
    exit( 1 );
  }

  string config( argv[ 1 ] );
  void* handle = ( void* )__init( config.c_str() );

  cerr<<argv[ 2 ]<<"\n"<<flush;
  ifstream infile( argv[ 2 ] );
  if ( !infile ) {
    cerr<<"Can not open file "<<argv[ 1 ]<<"\n"<<flush;
    exit( 1 );
  }

  FILE *outfile = fopen(argv[3] , "w");

  string sentence;
  int lineNo = 0;
  while ( getline( infile, sentence ) ) {
    ++lineNo;
    if( lineNo % 10000 == 0 )
    {
        fprintf(stderr,"\r\tprocessed %d lines." , lineNo );
    }
	char * output = __do_job(handle, sentence.c_str(), sentence.c_str(), 0, 1, "");
    fprintf( outfile , "%s\n" , output );
    delete []output;
  }
  infile.clear();
  infile.close();
  fclose(outfile);

  __destroy( handle );
  return 0;
}



