// mteval2.cpp : Defines the entry point for the console application.

//#undef _HAVE_ICT
#define _HAVE_ICT
#undef _HAVE_ICTCLAS

//
// History:
// 
// version 863 -- by hxhou@ict.ac.cn
//    * implement GTM, mWER, mPER score
//    * can process chinese/japanese
//    * support unicode
//    * change some tags: seg->s, sysid->site, DOC->doc
//
// version 11a -- corrected output of individual n-gram precision values
//
// version 11 -- bug fixes:
//    * make filehandle operate in binary mode to prevent Perl from operating
//      (by default in Red Hat 9) in UTF-8
//    * fix failure on joining digits
// version 10 -- updated output to include more details of n-gram scoring.
//    Defaults to generate both NIST and BLEU scores.  Use -b for BLEU
//    only, use -n for NIST only
//
// version 09d -- bug fix (for BLEU scoring, ngrams were fixed at 4
//    being the max, regardless what was entered on the command line.)
//
// version 09c -- bug fix (During the calculation of ngram information,
//    each ngram was being counted only once for each segment.  This has
//    been fixed so that each ngram is counted correctly in each segment.)
//
// version 09b -- text normalization modified:
//    * option flag added to preserve upper case
//    * non-ASCII characters left in place.
//
// version 09a -- text normalization modified:
//    * &quot; and &amp; converted to "" and &, respectively
//    * non-ASCII characters kept together (bug fix)
//
// version 09 -- modified to accommodate sgml tag and attribute
//    names revised to conform to default SGML conventions.
//
// version 08 -- modifies the NIST metric in accordance with the
//    findings on the 2001 Chinese-English dry run corpus.  Also
//    incorporates the BLEU metric as an option and supports the
//    output of ngram detail.
//
// version 07 -- in response to the MT meeting on 28 Jan 2002 at ISI
//    Keep strings of non-ASCII characters together as one word
//    (rather than splitting them into one-character words).
//    Change length penalty so that translations that are longer than
//    the average reference translation are not penalized.
//
// version 06
//    Prevent divide-by-zero when a segment has no evaluation N-grams.
//    Correct segment index for level 3 debug output.
//
// version 05
//    improve diagnostic error messages
//
// version 04
//    tag segments
//
// version 03
//    add detailed output option (intermediate document and segment scores)
//
// version 02
//    accommodation of modified sgml tags and attributes
//
// version 01
//    same as bleu version 15, but modified to provide formal score output.
//
// original IBM version
//    Author: Kishore Papineni
//    Date: 06/10/2001
//////////////////////////////////////////////////////////////////////////////

// Intro

#include "MTEvalLib.h"
#include<stdio.h>
#include <stdlib.h>
#include<time.h>

#ifdef _HAVE_ICTCLAS
#include "../include/ICTCLAS.h"
ICTCLAS * ictclas;
#endif


SITEMAP refs;
SITEMAP tsts;
DOCMAP srcs;
GRAMMAP ngram_info;
VOCAB voc;

int detail;
int preserve_case;
int quiet;
int showngram;
tstring method;
tstring src_lang;
tstring tgt_lang;

void print_usage()
{
	tstring usage = _T("\n\nUsage: mteval [-h] -r <ref_file> -s <src_file> -t <tst_file>\n\n")
    _T("Description:  This program evaluates MT system performance.\n")
    _T("\n")
    _T("Required arguments:\n")
    _T("  -r <ref_file> is a file containing the reference translations for\n")
    _T("      the documents to be evaluated.\n")
    _T("  -s <src_file> is a file containing the source documents for which\n")
    _T("      translations are to be evaluated\n")
    _T("  -t <tst_file> is a file containing the translations to be evaluated\n")
    _T("\n")
    _T("Optional arguments:\n")
	_T("  -e input file as SGM file format(for NIST evaluation)\n")
    _T("  -c preserves upper-case alphabetic characters\n")
    _T("  -b generate BLEU scores only\n")
    _T("  -n generate NIST scores only\n")
    _T("  -g generate GTM scores only\n")
    _T("  -w generate mWER scores only\n")
    _T("  -p generate mPER scores only\n")
	_T("  -o output NIST & BLEU only\n")
    _T("  -d detailed output flag used in conjunction with \"-b\", \"-n\" or \"-g\" flags:\n")
    _T("         0 (default) for system-level score only\n")
    _T("         1 to include document-level scores\n")
    _T("         2 to include segment-level scores\n")
    _T("         3 to include ngram-level scores\n")
    _T("  -q quiet\n")
    _T("  -h prints this help message to STDOUT\n")
    _T("\n");
	_tprintf(_T("%s\n"),usage.c_str());
}

int get_opt_bool(int argc, TCHAR * argv[], const TCHAR * opt)
{
	int i;
	for(i=1;i<argc;i++)
	{
		if (!argv[i][0])
			continue;
		if (argv[i][0]=='-' && _tcscmp(argv[i]+1,opt)==0)
			break;
	}
	return i<argc;
}

tstring get_opt_string(int argc, TCHAR * argv[], const TCHAR * opt)
{
	int i;
	for(i=1;i<argc;i++)
	{
		if (!argv[i][0])
			continue;
		if (argv[i][0]=='-' && _tcscmp(argv[i]+1,opt)==0)
			break;
	}
	if (i<argc)
	{
		tstring s;
		s=&argv[i][2];
		if (i<argc-1 && argv[i+1][0]!=0 && argv[i+1][0]!='-')
		{
			s+=argv[i+1];
		}
		return s;
	}
	else
		return _T("");
}

void date_time_stamp(tstring & d, tstring & t)
{
	struct tm * xtm;
    TCHAR * months[] = { _T("Jan"), _T("Feb"), _T("Mar"), _T("Apr"),
		_T("May"), _T("Jun"), _T("Jul"), _T("Aug"),
		_T("Sep"), _T("Oct"), _T("Nov"), _T("Dec") };
	TCHAR s[81];
	time_t xt=time(NULL);
	xtm=localtime(&xt);
	_stprintf(s,_T("%02d:%02d:%02d"),xtm->tm_hour,xtm->tm_min,xtm->tm_sec);
	t=s;
	_stprintf(s,_T("%4d %3s %d"),1900+xtm->tm_year,months[xtm->tm_mon],xtm->tm_mday);
	d=s;
}

#ifdef _HAVE_ICTCLAS
void mysegmenter(const string & sent, vector<string> & words, const tstring & lang)
{
	if (ictclas && (_tcsicmp(lang.c_str(),_T("cn"))==0||_tcsicmp(lang.c_str(),_T("zh"))==0||_tcsicmp(lang.c_str(),_T("chinese"))==0))
	{
		char * buf;
		buf=new char[sent.length()*2*4+1];
		segtagICTCLAS_Paragraph(ictclas,utoloc(sent,EC_GB).c_str(),buf);
		int p,q;
		string s;
		s=loctou(buf,EC_GB);
		words.clear();
		p=0;
		while (p<(int)s.length() && p>=0)
		{
			string t;
			q=s.find(' ',p);
			if (q<0)
				q=s.length();
			t=s.substr(p,q-p);
			p=q+1;
			if (!t.empty())
			{
				words.push_back(t);
			}
		}
		delete[] buf;
	}
	else
		defaultwordsegmenter(sent,words,lang);
}
#endif

int main(int argc, TCHAR * argv[])
{
	setlocale(LC_ALL,"");
	clock_t nBeginRead,nBeginEval,nBeginNGram,nEnd;

	tstring date, time;
	date_time_stamp(date,time);

	_tprintf(_T("MT evaluation scorer began on %s at %s\n"),date.c_str(),time.c_str());


	tstring srcfile,reffile,tstfile,o_detail;
	int o_help,o_bleu,o_nist,o_gtm,o_case,o_quiet,o_mper,o_mwer,o_ngram,o_evalnist,o_nb;
#ifdef _HAVE_ICTCLAS
	int o_ictclas;
#endif
#ifdef _HAVE_ICT
	int o_ict;
#endif

	srcfile=get_opt_string(argc,argv,_T("s")); // source file
	reffile=get_opt_string(argc,argv,_T("r")); // reference file
	tstfile=get_opt_string(argc,argv,_T("t")); // test file
	o_detail=get_opt_string(argc,argv,_T("d")); // detail
	o_help=get_opt_bool(argc,argv,_T("h")); // help
	o_bleu=get_opt_bool(argc,argv,_T("b")); // BLEU
	o_nist=get_opt_bool(argc,argv,_T("n")); // NIST
	o_gtm=get_opt_bool(argc,argv,_T("g"));  // GTM
	o_mwer=get_opt_bool(argc,argv,_T("w")); // mWER
	o_mper=get_opt_bool(argc,argv,_T("p")); // mPER
#ifdef _HAVE_ICT
	o_ict=get_opt_bool(argc,argv,_T("i")); // ICT
#endif
#ifdef _HAVE_ICTCLAS
	o_ictclas=get_opt_bool(argc,argv,_T("ictclas")); // ICTCLAS
#endif
	o_case=get_opt_bool(argc,argv,_T("c")); // case sensitive
	o_quiet=get_opt_bool(argc,argv,_T("q")); // quiet
	o_ngram=get_opt_bool(argc,argv,_T("x")); // ngram info
	o_evalnist=get_opt_bool(argc,argv,_T("e")); // evaluate NIST files
	o_nb=get_opt_bool(argc,argv,_T("o"));
//	cout<<_T("hello")<<endl;
//	_tprintf(_T("%s\n"),srcfile.c_str());
//	print_usage();

	detail=_tcstol(o_detail.c_str(),NULL,10);
	preserve_case=o_case;
	quiet=o_quiet;
	showngram=o_ngram;
#ifdef _HAVE_ICTCLAS
	if (o_ictclas)
	{
		ictclas=initICTCLAS("DataForICTCLAS\\ICTCLAS.xml");
		if (ictclas)
			setwordsegmenter(mysegmenter);
	}
#endif
//	setdetail(detail);
//	setcase(preserve_case);
    
	if (o_help || srcfile.length()==0 || reffile.length()==0 || tstfile.length()==0)
	{
		print_usage();
		return 0;
	}

	tstring METHOD;

	METHOD=_T("ALL");
	if (o_nb) METHOD=_T("NB");
	if (o_bleu) METHOD=_T("BLEU");
	if (o_nist) METHOD=_T("NIST");
	if (o_gtm) METHOD=_T("GTM");
	if (o_mwer) METHOD=_T("mWER");
	if (o_mper) METHOD=_T("mPER");
#ifdef _HAVE_ICT
	if (o_ict) METHOD=_T("ICT");
#endif

	nBeginRead=clock();
	if (o_evalnist)
	{
		src_lang=sgm_get_source_info(srcs,srcfile);
		tgt_lang=sgm_get_ref_data("refset",refs,voc,preserve_case,reffile);
		sgm_get_tst_data("tstset",tsts,voc,preserve_case,tstfile);
	}
	else
	{
		src_lang=get_source_info(srcs,srcfile);
		tgt_lang=get_ref_data("refset",refs,voc,preserve_case,reffile);
		get_tst_data("tstset",tsts,voc,preserve_case,tstfile);
	}

	nBeginNGram=clock();

	if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("NIST") || METHOD==_T("BLEU") || showngram)
	{
		compute_ngram_info(refs,ngram_info);	
	}

	nBeginEval=clock();
	NSCOREMAP xNISTmt;
	NSCOREMAP xBLEUmt;
	NSCOREMAP xBLEUSBPmt;	//>< added by xiejun for bleu_sbp 20090617
	SITESCORE NISTmt;
	SITESCORE BLEUmt;
	SITESCORE BLEUSBPmt;	//>< added by xiejun for bleu_sbp 20090617
	SITESCORE GTMmt;
	SITESCORE mWERmt;
	SITESCORE mPERmt;
#ifdef _HAVE_ICT
	SITESCORE ICTmt;
#endif

	int cum_seg = 0;
	DOCMAP::const_iterator itx;

	_tprintf(_T("  Evaluation of %s-to-%s translation using:\n"),src_lang.c_str(),tgt_lang.c_str());

	for(itx=srcs.begin();itx!=srcs.end();itx++)
	{
		const SEGMAP & segs=itx->second;
		cum_seg += segs.size();
	}
	_tprintf(_T("    src set (%d docs, %d segs)\n"), srcs.size(), cum_seg);
	_tprintf(_T("    ref set (%d refs)\n"), refs.size());
	_tprintf(_T("    tst set (%d systems)\n\n"), tsts.size());

	SITEMAP::const_iterator it1;

	for(it1=tsts.begin();it1!=tsts.end();it1++)
	{
		const DOCMAP & docs=it1->second;
		string site=it1->first;
	
		int n;
		xNISTmt[site].resize(max_Ngram);
		xBLEUmt[site].resize(max_Ngram);
		for(n=0;n<max_Ngram;n++)
		{
			xNISTmt[site][n].cum=0;
			xNISTmt[site][n].ind=0;
			xBLEUmt[site][n].cum=0;
			xBLEUmt[site][n].ind=0;
		}

		if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("NIST"))
		{
			method=_T("NIST");
			score_system(refs,tsts,ngram_info,site,xNISTmt,1,NISTmt);

			if (detail>=1)
			{
				DOCSCORE::iterator it2;
				for(it2=NISTmt[site].second.begin();it2!=NISTmt[site].second.end();it2++)
				{
					if (detail>=2)
					{
						SEGSCORE::iterator it3;
						for(it3=it2->second.second.begin();it3!=it2->second.second.end();it3++)
						{
							_tprintf(_T("  %s score using %d-grams = %7.4f for system \"%s\" on segment %d of document \"%s\" (%d words)\n"),
								method.c_str(),NIST_ORDER,it3->second.first,u2t(site).c_str(),it3->first,u2t(it2->first).c_str(),it3->second.second);
						}
					}
					_tprintf(_T("%s score using %d-grams = %7.4f for system \"%s\" on document \"%s\" (%d segments, %d words)\n"),
						method.c_str(),NIST_ORDER,it2->second.first.first,u2t(site).c_str(),u2t(it2->first).c_str(),it2->second.second.size(),it2->second.first.second);
				}
				_tprintf(_T("\n"));
			}
		}
		if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("BLEU"))
		{
			method=_T("BLEU");
			score_system(refs,tsts,ngram_info,site,xBLEUmt,0,BLEUmt);
			if (detail>=1)
			{
				DOCSCORE::iterator it2;
				for(it2=BLEUmt[site].second.begin();it2!=BLEUmt[site].second.end();it2++)
				{
					if (detail>=2)
					{
						SEGSCORE::iterator it3;
						for(it3=it2->second.second.begin();it3!=it2->second.second.end();it3++)
						{
							_tprintf(_T("  %s score using %d-grams = %.4f for system \"%s\" on segment %d of document \"%s\" (%d words)\n"),
								method.c_str(),BLEU_ORDER,it3->second.first,u2t(site).c_str(),it3->first,u2t(it2->first).c_str(),it3->second.second);
						}
					}
					_tprintf(_T("%s score using %d-grams = %.4f for system \"%s\" on document \"%s\" (%d segments, %d words)\n"),
						method.c_str(),BLEU_ORDER,it2->second.first.first,u2t(site).c_str(),u2t(it2->first).c_str(),it2->second.second.size(),it2->second.first.second);
				}
				_tprintf(_T("\n"));
			}

			//>< added by xiejun for bleu_sbp 20090617 --->beg
			score_system(refs,tsts,ngram_info,site,xBLEUSBPmt,-1,BLEUSBPmt);
			if (detail>=1)
			{
				DOCSCORE::iterator it2;
				for(it2=BLEUSBPmt[site].second.begin();it2!=BLEUSBPmt[site].second.end();it2++)
				{
					if (detail>=2)
					{
						SEGSCORE::iterator it3;
						for(it3=it2->second.second.begin();it3!=it2->second.second.end();it3++)
						{
							_tprintf(_T("  %s score using %d-grams = %.4f for system \"%s\" on segment %d of document \"%s\" (%d words)\n"),
								method.c_str(),BLEU_ORDER,it3->second.first,u2t(site).c_str(),it3->first,u2t(it2->first).c_str(),it3->second.second);
						}
					}
					_tprintf(_T("%s score using %d-grams = %.4f for system \"%s\" on document \"%s\" (%d segments, %d words)\n"),
						method.c_str(),BLEU_ORDER,it2->second.first.first,u2t(site).c_str(),u2t(it2->first).c_str(),it2->second.second.size(),it2->second.first.second);
				}
				_tprintf(_T("\n"));
			}
			//>< added by xiejun for bleu_sbp 20090617 --->end
		}

		if (METHOD==_T("ALL") || METHOD==_T("GTM"))
		{
			method=_T("GTM");
			gtm_score_system(refs,tsts,site,GTMmt);
			if (detail>=1)
			{
				DOCSCORE::iterator it2;
				for(it2=GTMmt[site].second.begin();it2!=GTMmt[site].second.end();it2++)
				{
					if (detail>=2)
					{
						SEGSCORE::iterator it3;
						for(it3=it2->second.second.begin();it3!=it2->second.second.end();it3++)
						{
							_tprintf(_T("  %s score = %.4f for system \"%s\" on segment %d of document \"%s\" (%d words)\n"),
								method.c_str(),it3->second.first,u2t(site).c_str(),it3->first,u2t(it2->first).c_str(),it3->second.second);
						}
					}
					_tprintf(_T("%s score = %.4f for system \"%s\" on document \"%s\" (%d segments, %d words)\n"),
						method.c_str(),it2->second.first.first,u2t(site).c_str(),u2t(it2->first).c_str(),it2->second.second.size(),it2->second.first.second);
				}
				_tprintf(_T("\n"));
			}
		}

		if (METHOD==_T("ALL") || METHOD==_T("mWER"))
		{
			method=_T("mWER");
			mwer_score_system(refs,tsts,site,mWERmt);
			if (detail>=1)
			{
				DOCSCORE::iterator it2;
				for(it2=mWERmt[site].second.begin();it2!=mWERmt[site].second.end();it2++)
				{
					if (detail>=2)
					{
						SEGSCORE::iterator it3;
						for(it3=it2->second.second.begin();it3!=it2->second.second.end();it3++)
						{
							_tprintf(_T("  %s score = %.4f for system \"%s\" on segment %d of document \"%s\" (%d words)\n"),
								method.c_str(),it3->second.first,u2t(site).c_str(),it3->first,u2t(it2->first).c_str(),it3->second.second);
						}
					}
					_tprintf(_T("%s score = %.4f for system \"%s\" on document \"%s\" (%d segments, %d words)\n"),
						method.c_str(),it2->second.first.first,u2t(site).c_str(),u2t(it2->first).c_str(),it2->second.second.size(),it2->second.first.second);
				}
				_tprintf(_T("\n"));
			}
		}
		if (METHOD==_T("ALL") || METHOD==_T("mPER"))
		{
			method=_T("mPER");
			mper_score_system(refs,tsts,site,mPERmt);
			if (detail>=1)
			{
				DOCSCORE::iterator it2;
				for(it2=mPERmt[site].second.begin();it2!=mPERmt[site].second.end();it2++)
				{
					if (detail>=2)
					{
						SEGSCORE::iterator it3;
						for(it3=it2->second.second.begin();it3!=it2->second.second.end();it3++)
						{
							_tprintf(_T("  %s score = %.4f for system \"%s\" on segment %d of document \"%s\" (%d words)\n"),
								method.c_str(),it3->second.first,u2t(site).c_str(),it3->first,u2t(it2->first).c_str(),it3->second.second);
						}
					}
					_tprintf(_T("%s score = %.4f for system \"%s\" on document \"%s\" (%d segments, %d words)\n"),
						method.c_str(),it2->second.first.first,u2t(site).c_str(),u2t(it2->first).c_str(),it2->second.second.size(),it2->second.first.second);
				}
				_tprintf(_T("\n"));
			}
		}
#ifdef _HAVE_ICT
		if (METHOD==_T("ALL") || METHOD==_T("ICT"))
		{
			method=_T("ICT");
			ict_score_system(refs,tsts,site,ICTmt);
			if (detail>=1)
			{
				DOCSCORE::iterator it2;
				for(it2=ICTmt[site].second.begin();it2!=ICTmt[site].second.end();it2++)
				{
					if (detail>=2)
					{
						SEGSCORE::iterator it3;
						for(it3=it2->second.second.begin();it3!=it2->second.second.end();it3++)
						{
							_tprintf(_T("  %s score = %.4f for system \"%s\" on segment %d of document \"%s\" (%d words)\n"),
								method.c_str(),it3->second.first,u2t(site).c_str(),it3->first,u2t(it2->first).c_str(),it3->second.second);
						}
					}
					_tprintf(_T("%s score = %.4f for system \"%s\" on document \"%s\" (%d segments, %d words)\n"),
						method.c_str(),it2->second.first.first,u2t(site).c_str(),u2t(it2->first).c_str(),it2->second.second.size(),it2->second.first.second);
				}
				_tprintf(_T("\n"));
			}
		}
#endif

	}

	nEnd=clock();

	for(it1=tsts.begin();it1!=tsts.end();it1++)
	{
		string site=it1->first;
		if (METHOD==_T("ALL"))
		{
			//>< modified by xiejun for bleu_sbp and new output format
//#ifdef _HAVE_ICT
//            _tprintf(_T("NIST score = %7.4f BLEU score = %.4f GTM score = %.4f mWER score = %.4f mPER score = %.4f ICT score = %.4f for system \"%s\"\n"),
//#else
//			_tprintf(_T("NIST score = %7.4f BLEU score = %.4f GTM score = %.4f mWER score = %.4f mPER score = %.4f for system \"%s\"\n"),
//#endif
//            	NISTmt[site].first.first,BLEUmt[site].first.first,GTMmt[site].first.first,mWERmt[site].first.first,mPERmt[site].first.first,
//#ifdef _HAVE_ICT
//				ICTmt[site].first.first,
//#endif
//				u2t(site).c_str());

			_tprintf(_T("Scores of system: %s\n"), u2t(site).c_str());
#ifdef _HAVE_ICT
			_tprintf(_T("NIST=%-7.4f BLEU=%.4f BLEU_SBP=%.4f GTM=%.4f mWER=%.4f mPER=%.4f ICT=%.4f\n"),
				NISTmt[site].first.first,BLEUmt[site].first.first,BLEUSBPmt[site].first.first,GTMmt[site].first.first,mWERmt[site].first.first,mPERmt[site].first.first,ICTmt[site].first.first);
#else
			_tprintf(_T("NIST=%-7.4f BLEU=%.4f BLEU-SBP=%.4f GTM=%.4f mWER=%.4f mPER=%.4f\n"),
				NISTmt[site].first.first,BLEUmt[site].first.first,BLEUSBPmt[site].first.first,GTMmt[site].first.first,mWERmt[site].first.first,mPERmt[site].first.first,ICTmt[site].first.first);
#endif

		}
		else
		if (METHOD==_T("NB"))
		{
            _tprintf(_T("NIST score = %7.4f BLEU score = %.4f for system \"%s\"\n"),
            	NISTmt[site].first.first,BLEUmt[site].first.first,u2t(site).c_str());
		}
		else
		if (METHOD==_T("NIST"))
		{
            _tprintf(_T("NIST score = %7.4f for system \"%s\"\n"),
            	NISTmt[site].first.first,u2t(site).c_str());
		}
		else
		if (METHOD==_T("BLEU"))
		{
            _tprintf(_T("BLEU score = %.4f for system \"%s\"\n"),
            	BLEUmt[site].first.first,u2t(site).c_str());
		}
		else
		if (METHOD==_T("GTM"))
		{
            _tprintf(_T("GTM score = %.4f for system \"%s\"\n"),
            	GTMmt[site].first.first,u2t(site).c_str());
		}
		else
		if (METHOD==_T("mWER"))
		{
            _tprintf(_T("mWER score = %.4f for system \"%s\"\n"),
            	mWERmt[site].first.first,u2t(site).c_str());
		}
		else
		if (METHOD==_T("mPER"))
		{
            _tprintf(_T("mPER score = %.4f for system \"%s\"\n"),
            	mPERmt[site].first.first,u2t(site).c_str());
		}
#ifdef _HAVE_ICT
		else
		if (METHOD==_T("ICT"))
		{
			_tprintf(_T("ICT score = %.4f for system \"%s\"\n"),
				ICTmt[site].first.first,u2t(site).c_str());
		}
#endif
	}

	if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("NIST") || METHOD==_T("BLEU"))
	{
		_tprintf (_T("\n# ------------------------------------------------------------------------\n"));
		_tprintf (_T("Individual N-gram scoring\n"));
		_tprintf (_T("        1-gram   2-gram   3-gram   4-gram   5-gram   6-gram   7-gram   8-gram   9-gram\n"));
		_tprintf (_T("        ------   ------   ------   ------   ------   ------   ------   ------   ------\n"));
	}
  
    if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("NIST"))
	{
		SITEMAP::const_iterator it;
        for(it=tsts.begin();it!=tsts.end();it++)
		{
			const string & site=it->first;
			int i;
            _tprintf (_T(" NIST:"));
            for (i=0; i<max_Ngram; i++)
			{
                _tprintf( _T(" %7.4f "),xNISTmt[site][i].ind);
            }
           _tprintf (_T("\"%s\"\n"), u2t(site).c_str());
        }
	    _tprintf (_T("\n"));
    }
    if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("BLEU"))
	{
		SITEMAP::const_iterator it;
        for(it=tsts.begin();it!=tsts.end();it++)
		{
			const string & site=it->first;
			int i;
            _tprintf (_T(" BLEU:"));
            for (i=0; i<max_Ngram; i++)
			{
                _tprintf( _T(" %7.4f "),xBLEUmt[site][i].ind);
            }
           _tprintf (_T("\"%s\"\n"), u2t(site).c_str());

			////><added by  xiejun for bleu_sbp 20090617 -->beg
		 //  _tprintf (_T(" BLEU-SBP:"));
		 //  for (i=0; i<max_Ngram; i++)
		 //  {
			//   _tprintf( _T(" %7.4f "),xBLEUSBPmt[site][i].ind);
		 //  }
		 //  _tprintf (_T("\"%s\"\n"), u2t(site).c_str());
		 //  //><added by  xiejun for bleu_sbp 20090617 -->end
        }
	    _tprintf (_T("\n"));
    }

	if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("NIST") || METHOD==_T("BLEU"))
	{
		_tprintf (_T("\n# ------------------------------------------------------------------------\n"));
		_tprintf (_T("Cumulative N-gram scoring\n"));
		_tprintf (_T("            1-gram   2-gram   3-gram   4-gram   5-gram   6-gram   7-gram   8-gram   9-gram\n"));
		_tprintf (_T("            ------   ------   ------   ------   ------   ------   ------   ------   ------\n"));
	}
  
    if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("NIST"))
	{
		SITEMAP::const_iterator it;
        for(it=tsts.begin();it!=tsts.end();it++)
		{
			const string & site=it->first;
			int i;
            _tprintf (_T(" NIST:    "));
            for (i=0; i<max_Ngram; i++)
			{
                _tprintf( _T(" %7.4f "),xNISTmt[site][i].cum);
            }
           _tprintf (_T("\"%s\"\n"), u2t(site).c_str());
        }
	    _tprintf (_T("\n"));
    }
    if (METHOD==_T("ALL") || METHOD==_T("NB") || METHOD==_T("BLEU"))
	{
		SITEMAP::const_iterator it;
        for(it=tsts.begin();it!=tsts.end();it++)
		{
			const string & site=it->first;
			int i;
            _tprintf (_T(" BLEU:    "));
            for (i=0; i<max_Ngram; i++)
			{
                _tprintf( _T(" %7.4f "),xBLEUmt[site][i].cum);
            }
           _tprintf (_T("\"%s\"\n"), u2t(site).c_str());

			//><added by  xiejun for bleu_sbp 20090617 -->beg
		   _tprintf (_T(" BLEU_SBP:"));
		   for (i=0; i<max_Ngram; i++)
		   {
			   _tprintf( _T(" %7.4f "),xBLEUSBPmt[site][i].cum);
		   }
		   _tprintf (_T("\"%s\"\n"), u2t(site).c_str());
		   //><added by  xiejun for bleu_sbp 20090617 -->end
        }
	    _tprintf (_T("\n"));
    }
 
	date_time_stamp(date,time);

#ifdef _HAVE_ICTCLAS
	if (ictclas)
		exitICTCLAS(ictclas);
#endif

	_tprintf(_T("MT evaluation scorer ended on %s at %s\n"),date.c_str(),time.c_str());

//	_tprintf(_T("Read file: %.4f\nNGram: %.4f\nEval: %.4f\n"),
//			(double)(nBeginNGram-nBeginRead)/CLOCKS_PER_SEC,
//			(double)(nBeginEval-nBeginNGram)/CLOCKS_PER_SEC,
//			(double)(nEnd-nBeginEval)/CLOCKS_PER_SEC);
	
	return 0;
}
