
#pragma once

#pragma warning(disable:4503)
#pragma warning(disable:4786)

#include "xmlfunc.h"

#include<string>
#include<vector>
#include<map>

using namespace std;

const int max_Ngram=9;
const int NIST_ORDER=5;
const int BLEU_ORDER=4;

typedef struct {
	double cum;
	double ind;
} _cum_ind;

typedef vector<_cum_ind> nscore_struct;

typedef basic_string<int> SENT;
typedef map<string,int> VOCAB;

typedef map<SENT,double> GRAMMAP;

typedef map<int,SENT> SEGMAP;
typedef map<string,SEGMAP> DOCMAP;
typedef map<string,DOCMAP> SITEMAP;

typedef pair<double,int> SCORE;
typedef map<int,SCORE> SEGSCORE; // segid, score
typedef map<string,pair<SCORE,SEGSCORE> > DOCSCORE; // docid,score
typedef map<string,pair<SCORE,DOCSCORE> > SITESCORE; // site,score

typedef map<string,double> SCOREMAP;
typedef map<string,nscore_struct> NSCOREMAP;

tstring get_ref_data(const string & setid, SITEMAP & docs, VOCAB & voc, int preserve_case, const tstring & fn);
tstring get_tst_data(const string & setid, SITEMAP & docs, const VOCAB & voc, int preserve_case, const tstring & fn);
tstring get_source_info(DOCMAP & srcs, const tstring & fn);
tstring sgm_get_ref_data(const string & setid, SITEMAP & docs, VOCAB & voc, int preserve_case, const tstring & fn);
tstring sgm_get_tst_data(const string & setid, SITEMAP & docs, const VOCAB & voc, int preserve_case, const tstring & fn);
tstring sgm_get_source_info(DOCMAP & srcs, const tstring & fn);
void compute_ngram_info(const SITEMAP & refs, GRAMMAP & ngram_info);


// Score NIST and BLEU
// parameter: nist: non-zero for nist, and zero of bleu
void score_system(const SITEMAP & refs, const SITEMAP & tsts, const GRAMMAP & ngram_info,const string & site, NSCOREMAP & SCOREmt,int nist, SITESCORE & score);
double mper_score_system(const SITEMAP & refs, const SITEMAP & tsts, const string & site, SITESCORE & score);
double mwer_score_system(const SITEMAP & refs, const SITEMAP & tsts, const string & site, SITESCORE & score);
double gtm_score_system(const SITEMAP & refs, const SITEMAP & tsts, const string & site, SITESCORE & score);
double ict_score_system(const SITEMAP & refs, const SITEMAP & tsts, const string & site, SITESCORE & score);

//void NormalizeText(string & s, const tstring & lang);
//void makelower(string & s);

//void setdetail(int dt);
//void setcase(int c);

typedef void (* PWORDSEGMENTER)(const string & sent, vector<string> & words, const tstring & lang);
void setwordsegmenter(PWORDSEGMENTER p);
void defaultwordsegmenter(const string & s, vector<string> & words, const tstring & lang);
