#include "xmlfunc.h"
#include <stdlib.h>
#include <stdio.h>
#include<malloc.h>
#if defined(_WIN32)

#include<windows.h>

#define LID_WCHAR 1200
#define LOC_WCHAR "UTF-16LE"

#else

#define LOC_WCHAR "wchar_t"
//#define LID_WCHAR 12000

#endif

#include<locale>
//#include<assert.h>
//#include<fstream>

using namespace std;

#define _CC_MLANG 1
#define _CC_ICONV 2
#define _CC_ICU 3

#ifdef _WIN32
#define _CONV_METHOD _CC_MLANG
//#define _CONV_METHOD _CC_ICONV
//#define _CONV_METHOD _CC_ICU
#else
#define _CONV_METHOD _CC_ICONV
//#define _CONV_METHOD _CC_ICU
#endif

#if _CONV_METHOD==_CC_MLANG
#include<MLang.h>
#endif

#if _CONV_METHOD==_CC_ICONV
#include<iconv.h>
#endif

#if _CONV_METHOD==_CC_ICU
#include<unicode/ucnv.h>
#include<unicode/ustring.h>
#endif

static struct {
	const char * name;
	XMLENC encoding;
} xmlenc[]= {
	{ "chinese",	EC_GB, },
	{ "gb2312",	EC_GB, },
	{ "gb231280",	EC_GB, },
	{ "gb2312-80",	EC_GB, },
	{ "csGB2312",	EC_GB, },
	{ "csGB231280",	EC_GB, },
	//	{ "HZ-GB-2312",	EC_GB, },
	{ "CN-GB",	EC_GB, },
	{ "GB_2312-80",	EC_GB, },
	{ "iso-ir-58",	EC_GB, },
	{ "csISO58GB231280",	EC_GB, },
	{ "gb18030",	EC_GB, },
	{ "gbk",	EC_GB, },
	{ "cp936",	EC_GB,	},

	{ "big5",	EC_BIG5, },
	{ "big5-hkscs",	EC_BIG5, },
	{ "x-x-big5",	EC_BIG5, },
	{ "cn-big5",	EC_BIG5, },
	{ "csbig5",	EC_BIG5, },

	{ "shift-jis",	EC_SJIS, },
	{ "shift_jis",	EC_SJIS, },
	{ "x-sjis",	EC_SJIS, },
	{ "MS_Kanji",	EC_SJIS, },
	{ "csShiftJIS",	EC_SJIS, },
	{ "csWindows31J",	EC_SJIS, },
	{ "x-ms-cp932",	EC_SJIS, },
	{ "sjis",	EC_SJIS, },

	{ "euc-jp",	EC_EUCJP, },
	{ "csEUCPkdFmtJapanese",	EC_EUCJP, },
	{ "Extended_UNIX_Code_Packed_Format_for_Japanese",	EC_EUCJP, },
	{ "x-euc",	EC_EUCJP, },
	{ "x-euc-jp",	EC_EUCJP, },

	{ "korean",	EC_EUCKR, },
	{ "csEUCKR",	EC_EUCKR, },
	{ "KSC_5601",	EC_EUCKR, },
	{ "KS_C_5601",	EC_EUCKR, },
	{ "KS_C_5601-1987",	EC_EUCKR, },
	{ "iso-ir-149",	EC_EUCKR, },
	{ "KS_C_5601-1989",	EC_EUCKR, },
	{ "csKSC56011987",	EC_EUCKR, },
	{ "ISO-2022-KR",	EC_EUCKR, },
	{ "csISO2022KR",	EC_EUCKR, },
	{ "euc-kr",	EC_EUCKR, },

	{ "ascii",	EC_ASCII,	},
	{ "IBM367",	EC_ASCII,	},
	{ "csASCII",	EC_ASCII,	},
	{ "ISO_646.irv:1991",	EC_ASCII,	},
	{ "ISO646-US",	EC_ASCII,	},
	{ "iso-ir-6us",	EC_ASCII,	},
	{ "ANSI_X3.4-1968",	EC_ASCII,	},
	{ "ANSI_X3.4-1986",	EC_ASCII,	},
	{ "us-ascii",	EC_ASCII,	},
	{ "cp819",	EC_ASCII,	},
	{ "ibm819",	EC_ASCII,	},
	{ "ISO_8859-1",	EC_ASCII,	},
	{ "ISO_8859-1:1987",	EC_ASCII,	},
	{ "ISO646-US",	EC_ASCII,	},
	{ "iso8859-1",	EC_ASCII,	},
	{ "iso-8859-1",	EC_ASCII,	},
	{ "iso-ir-100",	EC_ASCII,	},
	{ "iso-ir-6",	EC_ASCII,	},
	{ "latin1",	EC_ASCII,	},
	{ "us",	EC_ASCII,	},
	{ "x-ansi",	EC_ASCII,	},

	{ "cp1251",	EC_RUS_WIN,	},
	{ "x-cp1251",	EC_RUS_WIN,	},
	{ "ms-cyr",	EC_RUS_WIN,	},
	{ "windows-1251",	EC_RUS_WIN,	},
	{ "laint5",	EC_RUS_ISO,	},
	{ "iso-8859-5",	EC_RUS_ISO,	},
	{ "csISOLatinCyrillic",	EC_RUS_ISO,	},
	{ "cyrillic",	EC_RUS_ISO,	},
	{ "ISO_8859-5",	EC_RUS_ISO,	},
	{ "ISO_8859-5:1988",	EC_RUS_ISO,	},
	{ "iso-ir-144",	EC_RUS_ISO,	},
	{ "l5",	EC_RUS_ISO,	},
	{ "koi8-r",	EC_RUS_KOI8R,	},
	{ "cskoi8r",	EC_RUS_KOI8R,	},
	{ "koi",	EC_RUS_KOI8R,	},
	{ "koi8",	EC_RUS_KOI8R,	},
	{ "koi8r",	EC_RUS_KOI8R,	},

	{ "windows-1253",	EC_GREEK,	},
	{ "iso-8859-7",	EC_GREEK,	},
	{ "greek",	EC_GREEK,	},
	{ "csISOLatinGreek",	EC_GREEK,	},
	{ "ECMA-118",	EC_GREEK,	},
	{ "ELOT_928",	EC_GREEK,	},
	{ "greek8",	EC_GREEK,	},
	{ "ISO_8859-7:1987",	EC_GREEK,	},
	{ "iso-ir-126",	EC_GREEK,	},

	{ "utf-8",	EC_UTF8, },
	{ "utf-7",	EC_UTF7, },
	{ "unicode-1-1utf-7",	EC_UTF7, },
	{ "csunicode11utf7",	EC_UTF7, },
	{ "utf-16",	EC_UTF16LE, },
	{ "utf-16le",	EC_UTF16LE, },
	{ "unicode",	EC_UTF16LE,	},
	{ "unicodeFFFE", EC_UTF16BE, },
	{ "utf-16be", EC_UTF16BE, },
	{ "ucs-2",	EC_UTF16LE, },
	{ "iso-10646-ucs-2",	EC_UTF16LE, },
	{ "csucs2",	EC_UTF16LE, },
	{ "ucs-2le",	EC_UTF16LE, },
	{ "ucs-2be",	EC_UTF16BE, },
	{ "utf-32",	EC_UTF32LE, },
	{ "ucs-4",	EC_UTF32LE, },
	{ "iso-10646-ucs-4",	EC_UTF32LE, },
	{ "csucs4",	EC_UTF32LE, },
	{ "ucs-4le",	EC_UTF32LE, },
	{ "ucs-4be",	EC_UTF32BE, },
	{ "utf-32le",	EC_UTF32LE, },
	{ "utf-32be",	EC_UTF32BE, },
};

static inline int _isspace(wchar_t c)
{
	return c==0x20 || c>=0x9 && c<=0xd;
}

static inline int _isspace(char c)
{
	return c==0x20 || c>=0x9 && c<=0xd;
}

static inline char * mystrdup(const char * p)
{
	if (!p)
		return NULL;
	char * x;
	x=(char *)malloc(strlen(p)+1);
	if (x)
		strcpy(x,p);
	return x;
}

string w2c(const wstring & s)
{
	string r;
	w2c(r,s);
	return r;
}

void w2c(string & r, const wstring & s)
{
	locale loc("");
	char * oldlocale;
	char * p;
	p=setlocale(LC_ALL,"");
	if (p)
		oldlocale=mystrdup(p);
	else
		oldlocale=mystrdup("");
	wchar_t * w;
	const wchar_t * pw;
	char * c, * pc;
	mbstate_t state;
	size_t len;
	len=s.length();
	w=new wchar_t[len+1];
	wcscpy(w,s.c_str());
	c=new char[len*3+1];
	pw=w;
	pc=c;
	while(pw<w+len)
	{
		memset(&state,0,sizeof(state));
		if (use_facet<codecvt<wchar_t, char, mbstate_t> >(loc).out(state,
			pw,w+len,pw,
			pc,c+len*3,pc)==codecvt_base::error)
		{
			*pc='?';
			pc++;
		}
		pw++;
	}
	*pc=0;
	r=c;
	delete[] w;
	delete[] c;
	setlocale(LC_ALL,oldlocale);
	free(oldlocale);
}

wstring c2w(const string & s)
{
	wstring r;
	c2w(r,s);
	return r;
}

void c2w(wstring & r, const string & s)
{
	locale loc("");
	char * oldlocale;
	char * p;
	p=setlocale(LC_ALL,"");
	if (p)
		oldlocale=mystrdup(p);
	else
		oldlocale=mystrdup("");
	wchar_t * w, * pw;
	char * c;
	const char * pc;
	mbstate_t state;
	size_t len;
	len=s.length();
	c=new char[len+1];
	strcpy(c,s.c_str());
	w=new wchar_t[len+1];
	pc=c;
	pw=w;
	while (pc<c+len)
	{
		int x;
		memset(&state,0,sizeof(state));
		if ((x=use_facet<codecvt<wchar_t, char, mbstate_t> >(loc).in(state,
			pc,c+len,pc,
			pw,w+len,pw))==codecvt_base::error)
		{
			*pw='?';
			pw++;
		}
		pc++;
	}
	*pw=0;
	r=w;
	delete[] w;
	delete[] c;
	setlocale(LC_ALL,oldlocale);
	free(oldlocale);
}

wstring loctow(const string & s, XMLENCREF loc)
{
	wstring r;
	loctow(r,s,loc);
	return r;
}

void loctow(wstring & r, const string & s, XMLENCREF loc)
{
#if _CONV_METHOD == _CC_MLANG
	CoInitialize(NULL);
	IMultiLanguage * pp;
	CoCreateInstance(CLSID_CMultiLanguage,NULL,CLSCTX_INPROC_SERVER,IID_IMultiLanguage,(LPVOID *)&pp);
	if (pp)
	{
		MIMECSETINFO csi;
		pp->GetCharsetInfo((BSTR)c2w(loc).c_str(),&csi);
		IMLangConvertCharset * cc;
		pp->CreateConvertCharset(csi.uiInternetEncoding,LID_WCHAR,0,&cc);
		if (cc)
		{
			size_t len;
			char * c;
			wchar_t * w;
			size_t olen;
			len=s.length();
			c=new char[len+1];
			strcpy(c,s.c_str());
			w=new wchar_t[len+1];
			olen=len;
			cc->DoConversionToUnicode(c,&len,w,&olen);
			w[olen]=0;
			r=w;
			delete [] w;
			delete [] c;
			cc->Release();
		}
		pp->Release();
	}
	CoUninitialize();

#endif
#if _CONV_METHOD == _CC_ICONV
	iconv_t ic;
	ic=iconv_open(LOC_WCHAR,loc.c_str());
	if (ic!=(iconv_t)-1)
	{
		size_t len;
		char * c;
		wchar_t * w;
#ifdef _WIN32
		const
#endif
		char * pc;
		char * pw;
		size_t olen;
		len=s.length();
		c=new char[len+1];
		strcpy(c,s.c_str());
		w=new wchar_t[len+1];
		olen=len*sizeof(wchar_t);
		pc=c;
		pw=(char *)w;
		while (*pc)
		{
			iconv(ic,&pc,&len,&pw,&olen);
			if (*pc)
			{
				pc++;
				len--;
				*(wchar_t *)pw='?';
				pw+=sizeof(wchar_t);
				olen-=sizeof(wchar_t);
			}
			else
				break;
		}
		*(wchar_t *)pw=0;
		r=w;
		delete [] w;
		delete [] c;
		iconv_close(ic);
	}
#endif
#if _CONV_METHOD == _CC_ICU
	UConverter * uc;
	UErrorCode err;
	uc=ucnv_open(loc.c_str(),&err);
	if (uc)
	{
		UChar * x;
		int32_t olen;
		int32_t xc;
		int32_t len;
		len=s.length();
		x=new UChar[len+1];
		xc=len;
		olen=ucnv_toUChars(uc,x,xc,s.c_str(),len,&err);
		x[olen]=0;
		wchar_t * w;
		int32_t wc;
		int32_t wlen;
		w=new wchar_t[olen*2+1];
		wc=olen*2;
		u_strToWCS(w,wc,&wlen,x,olen,&err);
		w[wlen]=0;
		r=w;
		ucnv_close(uc);
		delete[] x;
	}
#endif
}

string wtoloc(const wstring & s, XMLENCREF loc)
{
	string r;
	wtoloc(r,s,loc);
	return r;
}

void wtoloc(string & r, const wstring & s, XMLENCREF loc)
{
#if _CONV_METHOD == _CC_MLANG
	CoInitialize(NULL);
	IMultiLanguage * pp;
	CoCreateInstance(CLSID_CMultiLanguage,NULL,CLSCTX_INPROC_SERVER,IID_IMultiLanguage,(LPVOID *)&pp);
	if (pp)
	{
		MIMECSETINFO csi;
		pp->GetCharsetInfo((BSTR)c2w(loc).c_str(),&csi);
		IMLangConvertCharset * cc;
		pp->CreateConvertCharset(LID_WCHAR,csi.uiInternetEncoding,0,&cc);
		if (cc)
		{
			size_t len;
			char * c;
			wchar_t * w;
			size_t olen;
			len=s.length();
			w=new wchar_t[len+1];
			wcscpy(w,s.c_str());
			c=new char[len*3+1];
			olen=len*3;
			cc->DoConversionFromUnicode(w,&len,c,&olen);
			c[olen]=0;
			r=c;
			delete [] w;
			delete [] c;
			cc->Release();
		}
		pp->Release();
	}
	CoUninitialize();
#endif
#if _CONV_METHOD == _CC_ICONV
	iconv_t ic;
	ic=iconv_open(loc.c_str(),LOC_WCHAR);
	if (ic!=(iconv_t)-1)
	{
		size_t len;
		char * c;
		wchar_t * w;
		char * pc;
#ifdef _WIN32
		const
#endif
		char * pw;
		size_t olen;
		len=s.length();
		w=new wchar_t[len+1];
		wcscpy(w,s.c_str());
		c=new char[len*3+1];
		olen=len*3;
		pc=c;
		pw=(char *)w;
		len*=sizeof(wchar_t);
		while (*(wchar_t *)pw)
		{
			iconv(ic,&pw,&len,&pc,&olen);
			if (*(wchar_t *)pw)
			{
				pw+=sizeof(wchar_t);
				len-=sizeof(wchar_t);
				*pc='?';
				pc++;
				olen--;
			}
			else
				break;
		}
		*pc=0;
		r=c;
		delete [] w;
		delete [] c;
		iconv_close(ic);
	}
#endif
#if _CONV_METHOD == _CC_ICU
	UConverter * uc;
	UErrorCode err;
	uc=ucnv_open(loc.c_str(),&err);
	if (uc)
	{
		UChar * x;
		int32_t olen;
		int32_t xc;
		int32_t len;
		len=s.length();
		x=new UChar[len+1];
		xc=len;
		u_strFromWCS(x,xc,&olen,s.c_str(),len,&err);
		x[olen]=0;
		char * c;
		int32_t cc;
		int32_t clen;
		c=new char[olen*3+1];
		cc=olen*3;
		clen=ucnv_fromUChars(uc,c,cc,x,olen,&err);
		c[clen]=0;
		r=c;
		ucnv_close(uc);
		delete[] x;
	}
#endif
}

string loctou(const string & str, XMLENCREF loc)
{
	string r;
	loctou(r,str,loc);
	return r;
}

void loctou(string & r, const string & str, XMLENCREF loc)
{
	wstring t;
	loctow(t,str,loc);
	w2u(r,t);
}

string utoloc(const string & str, XMLENCREF loc)
{
	string r;
	utoloc(r,str,loc);
	return r;
}

void utoloc(string & r, const string & str, XMLENCREF loc)
{
	wstring t;
	u2w(t,str);
	wtoloc(r,t,loc);
}

static wchar_t D[]=L"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'(),-./:?";
static wchar_t O[]=L"!\"#$%&*;<=>@[]^_`{|}";
static char B[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static inline int inD(wchar_t x)
{
	if (x<=0x20)
		return 1;
	int i;
	for(i=0;D[i];i++)
		if (x==D[i])
			break;
	return D[i];
}

static inline int inB(char x)
{
	int i;
	for(i=0;B[i];i++)
		if (x==B[i])
			break;
	return B[i];
}

string wtou7(const wstring & str)
{
	string r;
	wtou7(r,str);
	return r;
}

void wtou7(string & r, const wstring & str)
{
	r.clear();
	size_t len;
	size_t i;
	bool in;
	len=str.length();
	in=false;
	for(i=0;i<len;i++)
	{
		wchar_t c=str[i];
		size_t j;
		if (inD(c) || c=='+')
		{
			if (in)
			{
				if (c=='-' || inB((char)c))
					r+='-';
				in=false;
			}
			if (c=='+')
			{
				r+="+-";
			}
			else
			{
				r+=(char)c;
			}
		}
		else
		{
			if (!in)
			{
				r+='+';
				in=true;
			}
			vector<unsigned char> x;
			while (i<len && str[i]!='+' && !inD(str[i]))
			{
				wchar_t v=str[i];
				if (v>>16)
				{
					x.push_back(0xd8|(((v>>16)-1)>>2));
					x.push_back(((((v>>16)-1)&3)<<6)|((v&0xfc00)>>10));
					x.push_back(0xdc|((v&0x300)>>8));
					x.push_back(v&0xff);
				}
				else
				{
					x.push_back(v>>8);
					x.push_back(v&0xff);
				}
				i++;
			}
			i--;
			size_t xlen=x.size();
#define BX(k) ((k)<xlen?x[k]:0)
			for(j=0;j<(xlen+2)/3*3;j+=3)
			{
				if (j>=xlen) break;
				r+=(B[(BX(j)&0xfc)>>2]);
				r+=(B[((BX(j)&3)<<4)|((BX(j+1)&0xf0)>>4)]);
				if (j+1>=xlen) break;
				r+=(B[((BX(j+1)&0xf)<<2)|((BX(j+2)&0xc0)>>6)]);
				if (j+2>=xlen) break;
				r+=(B[BX(j+2)&0x3f]);
			}
		}
	}
	if (in)
		r+='-';
}

wstring u7tow(const string & str)
{
	wstring r;
	u7tow(r,str);
	return r;
}

void u7tow(wstring & r, const string & str)
{
	r.clear();
	static unsigned char b2c[96] =
	{
		/* from ' ' */
		/*20*/	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
		/*28*/	0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x3f,
		/*30*/	0x34,0x35,0x36,0x37,0x38,0x39,0x3a,0x3b,
		/*38*/	0x3c,0x3d,0x00,0x00,0x00,0x00,0x00,0x00,
		/*40*/	0x00,0x00,0x01,0x02,0x03,0x04,0x05,0x06,
		/*48*/	0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,
		/*50*/	0x0f,0x10,0x11,0x12,0x13,0x14,0x15,0x16,
		/*58*/	0x17,0x18,0x19,0x00,0x00,0x00,0x00,0x00,
		/*60*/	0x00,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x20,
		/*68*/	0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,
		/*70*/	0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x30,
		/*78*/	0x31,0x32,0x33,0x00,0x00,0x00,0x00,0x00,
	};
	size_t i,j;
	size_t len;
	len=str.length();
	for(i=0;i<len;i++)
	{
		char c;
		c=str[i];
		if (c=='+')
		{
			size_t v;
			string x;
			x="";
			v=i+1;
			while (v<len && inB(str[v]))
				v++;
			x=str.substr(i+1,v-i-1);
			if (v<len && str[v]=='-')
				i=v;
			else
				i=v-1;
			if (x.empty())
			{
				r+='+';
			}
			else
			{
				vector<unsigned char> y;
				size_t xlen=x.length();
				j=0;
				while(j<(xlen+3)/4*4)
				{
#define DX(x) ((x)>=0x20 && (x)<=0x7e?b2c[(x)-0x20]:0)
					y.push_back((DX(x[j])<<2)|((DX(x[j+1])&0x30)>>4));
					if (j+1>=xlen) break;
					y.push_back(((DX(x[j+1])&0xf)<<4)|((DX(x[j+2])&0x3c)>>2));
					if (j+2>=xlen) break;
					y.push_back(((DX(x[j+2])&0x3)<<6)|((DX(x[j+3])&0x3f)));
					j+=4;
				}
				size_t ylen=y.size();
				for(j=0;j+1<ylen;j+=2)
				{
					if (sizeof(wchar_t)==2 || (y[j]&0xfc)!=0xd8)
					{
						r+=((wchar_t)((y[j]<<8)|(y[j+1])));
					}
					else
					{
						unsigned short v1,v2;
						v1=((y[j]<<8)|(y[j+1]));
						if (j+2<ylen-1)
							v2=((y[j+2]<<8)|(y[j+3]));
						else
							v2=0;
						j+=2;
						r+=((wchar_t)(((((v1&0x3c0)>>6)+1)<<16)
							|((v1&0x3f)<<10)
							|(v2&0x3ff)));
					}
				}
			}
		}
		else
		{
			r+=(wchar_t)c;
		}
	}
}

string u7tou(const string & str)
{
	string r;
	u7tou(r,str);
	return r;
}

void u7tou(string & r, const string & str)
{
	wstring t;
	u7tow(t,str);
	w2u(r,t);
}

string utou7(const string & str)
{
	string r;
	utou7(r,str);
	return r;
}

void utou7(string & r, const string & str)
{
	wstring t;
	u2w(t,str);
	wtou7(r,t);
}

string c2u(const string & str)
{
	string r;
	c2u(r,str);
	return r;
}

void c2u(string & r, const string & str)
{
	wstring t;
	c2w(t,str);
	w2u(r,t);
}

string u2c(const string & str)
{
	string r;
	u2c(r,str);
	return r;
}

void u2c(string & r, const string & str)
{
	wstring t;
	u2w(t,str);
	w2c(r,t);
}

string w2u(const wstring & str)
{
	string r;
	w2u(r,str);
	return r;
}

void w2u(string & r, const wstring & str)
{
	r.clear();
	size_t i;
	size_t len;
	len=str.length();
	for(i=0;i<len;i++)
	{
		wchar_t c;
		unsigned char w;
		c=str[i];
		if (c>>16)
		{
			r+=(0xf0|((c&0x1c0000)>>18));
			r+=(0x80|((c&0x30000)>>12)|((c&0xf000)>>12));
			r+=(0x80|((c&0xfc0)>>6));
			w=0x80|(c&0x3f);
		}
		else if (sizeof(wchar_t)==2 && (c&0xfc00)==0xd800)
		{
			wchar_t c2;
			if (i+1<len)
			{
				c2=str[i+1];
				i++;
			}
			else
				c2=0;
			r+=(0xf0|((((c&0x3c0)>>6)+1)>>2));
			r+=(0x80|(((((c&0x3c0)>>6)+1)&3)<<4)|((c&0x3c)>>2));
			r+=(0x80|((c&3)<<4)|((c2&0x3c0)>>6));
			w=0x80|(c2&0x3f);
		}
		else if ((c&0xff80)==0)
		{
			w=(unsigned char)c;
		}
		else if ((c&0xf800)==0)
		{
			r+=(0xc0|(c>>6));
			w=0x80|(c&0x3f);
		}
		else
		{
			r+=(0xe0|(c>>12));
			r+=(0x80|((c&0xfc0)>>6));
			w=0x80|(c&0x3f);
		}
		r+=w;
	}
}

wstring u2w(const string & str)
{
	wstring r;
	u2w(r,str);
	return r;
}

void u2w(wstring & r, const string & str)
{
	r.clear();
	const char * s;
	for(s=str.c_str();*s;s++)
	{
		unsigned char c;
		wchar_t w;
		c=*s;
		if ((c&0xf8)==0xf0)
		{
			unsigned char c2;
			unsigned char c3;
			unsigned char c4;
			if (*(s+1)!=0)
			{
				c2=*(s+1);
				if (*(s+2)!=0)
				{
					c3=*(s+2);
					if (*(s+3)!=0)
					{
						c4=*(s+3);
						s++;
					}
					else
					{
						c4=0;
					}
					s++;
				}
				else
				{
					c3=0;
					c4=0;
				}
				s++;
			}
			else
			{
				c2=0;
				c3=0;
				c4=0;
			}
			if (sizeof(wchar_t)==2)
			{
				r+=(0xd800|(((((c&0x7)<<2)|((c2&0x30)>>4))-1)<<6)|((c2&0xf)<<2)|((c3&0x30)>>4));
				w=0xdc00|((c3&0xf)<<6)|(c4&0x3f);
			}
			else
			{
				w=((c&0x7)<<18)|((c2&0x3f)<<12)|((c3&0x3f)<<6)|(c4&0x3f);
			}
		}
		else if ((c&0xf0)==0xe0)
		{
			unsigned char c2;
			unsigned char c3;
			if (*(s+1)!=0)
			{
				c2=*(s+1);
				if (*(s+2)!=0)
				{
					c3=*(s+2);
					s++;
				}
				else
				{
					c3=0;
				}
				s++;
			}
			else
			{
				c2=0;
				c3=0;
			}
			w=(c3&0x3f)|((c2&0x3f)<<6)|((c&0xf)<<12);
		}
		else if ((c&0xe0)==0xc0)
		{
			unsigned char c2;
			if (*(s+1)!=0)
			{
				c2=*(s+1);
				s++;
			}
			else
			{
				c2=0;
			}
			w=(c2&0x3f)|((c&0x1f)<<6);
		}
		else
		{
			w=c;
		}
		r+=w;
	}
}

static inline size_t _findtag(const wstring & name, const wstring & data, size_t pos)
{
	size_t p;
	size_t dlen,nlen;
	dlen=data.length();
	nlen=name.length();
	p=pos-1;
	while (1)
	{
		p=data.find(L"<"+name,p+1);
		if (p==string::npos)
			break;
		size_t px;
		px=p+nlen+1;
		if (p>=dlen)
		{
			p=string::npos;
			break;
		}
		wchar_t c;
		c=data[px];
		if (_isspace(c) || c=='>' || c=='/')
			break;
	}
	return p;
}

int extract_tag_and_span(const wstring & name, wstring &data, wstring &tag, wstring &span)
{
	size_t p1,p2,p3;
	size_t dlen,nlen;
	tag.empty();
	span.empty();
	dlen=data.length();
	nlen=name.length();
	p1=_findtag(name,data,0);
	if (p1==string::npos)
		return 0;
	p2=data.find('>',p1);
	if (p2==string::npos)
		return 0;
	tag=data.substr(p1+nlen+1,p2-p1-nlen-1);
	if (p2>0 && data[p2-1]=='/')
	{
		data=data.substr(p2+1);
	}
	else
	{
		size_t p4;
		p3=data.find(L"</"+name+L">",p2);
		if (p3==string::npos)
		{
			p3=_findtag(name,data,p2);
			if (p3!=string::npos)
				p4=p3;
			else
				p3=p4=dlen;
		}
		else
			p4=p3+nlen+3;
		span=data.substr(p2+1,p3-p2-1);
		data=data.substr(p4);
	}
	return 1;
}

wstring extract_tag_attribute(const wstring & name, const wstring & data)
{
	wstring r;
	extract_tag_attribute(r,name,data);
	return r;
}

void extract_tag_attribute(wstring & r, const wstring & name, const wstring & data)
{
	vector<wstring> words;
	wstring cstr;

	size_t i;
	int w;
	w=0;
	cstr.clear();
	for(i=0;i<data.length();i++)
	{
		wchar_t c=data[i];
		if (w==0 && !_isspace(c) && c!='=' && c!='\'' && c!='\"')
		{
			w=1;
			cstr=c;
		}
		else if (w==1 && !_isspace(c) && c!='=' && c!='\'' && c!='\"')
		{
			cstr+=c;
		}
		else if (w==0 && c=='\"')
		{
			w=2;
			cstr=c;
		}
		else if (w==2 && c=='\"')
		{
			w=0;
			cstr+=c;
			words.push_back(cstr);
			cstr.clear();
		}
		else if (w==0 && c=='\'')
		{
			w=3;
			cstr=c;
		}
		else if (w==3 && c=='\'')
		{
			w=0;
			cstr+=c;
			words.push_back(cstr);
			cstr.clear();
		}
		else if (w==2||w==3)
		{
			cstr+=c;
		}
		else if (w==1)
		{
			w=0;
			words.push_back(cstr);
			if (!_isspace(c))
			{
				cstr=c;
				words.push_back(cstr);
			}
			cstr.clear();
		}
		else if (!_isspace(c))
		{
			w=0;
			words.push_back(cstr);
			cstr=c;
			words.push_back(cstr);
			cstr.clear();
		}
	}

	for(i=0;i+2<words.size();i++)
	{
		if (words[i].compare(name)==0 && words[i+1].compare(L"=")==0)
			break;
	}
	if (i+2<words.size())
	{
		wstring &ret=r;
		ret=words[i+2];
		if (ret.length()>0 && (ret[0]=='\"' || ret[0]=='\''))
			ret=ret.substr(1);
		if (ret.length()>0 && (ret[ret.length()-1]=='\"' || ret[ret.length()-1]=='\''))
			ret=ret.substr(0,ret.length()-1);
		return;
	}
	r.clear();
}

wstring combine_tag(const wstring & tag, const map<wstring,wstring> & attr, const wstring & data)
{
	wstring r;
	combine_tag(r,tag,attr,data);
	return r;
}

void combine_tag(wstring & r, const wstring & tag, const map<wstring,wstring> & attr, const wstring & data)
{
	r.clear();
	r+='<';
	r+=tag;
	map<wstring,wstring>::const_iterator it;
	for(it=attr.begin();it!=attr.end();it++)
	{
		r+=' ';
		r+=it->first;
		r+=L"=\"";
		r+=it->second;
		r+='\"';
	}
	r+='>';
	r+=data;
	r+=L"</";
	r+=tag;
	r+='>';
	return;
}

static inline size_t _findtag(const string & name, const string & data, size_t pos)
{
	size_t p;
	size_t dlen,nlen;
	dlen=data.length();
	nlen=name.length();
	p=pos-1;
	while (1)
	{
		p=data.find("<"+name,p+1);
		if (p==string::npos)
			break;
		size_t px;
		px=p+nlen+1;
		if (p>=dlen)
		{
			p=string::npos;
			break;
		}
		wchar_t c;
		c=data[px];
		if (_isspace(c) || c=='>' || c=='/')
			break;
	}
	return p;
}

int extract_tag_and_span(const string & name, string &data, string &tag, string &span)
{
	size_t p1,p2,p3;
	size_t dlen,nlen;
	tag.empty();
	span.empty();
	dlen=data.length();
	nlen=name.length();
	p1=_findtag(name,data,0);
	if (p1==string::npos)
		return 0;
	p2=data.find('>',p1);
	if (p2==string::npos)
		return 0;
	tag=data.substr(p1+nlen+1,p2-p1-nlen-1);
	if (p2>0 && data[p2-1]=='/')
	{
		data=data.substr(p2+1);
	}
	else
	{
		size_t p4;
		p3=data.find("</"+name+">",p2);
		if (p3==string::npos)
		{
			p3=_findtag(name,data,p2);
			if (p3!=string::npos)
				p4=p3;
			else
				p3=p4=dlen;
		}
		else
			p4=p3+nlen+3;
		span=data.substr(p2+1,p3-p2-1);
		data=data.substr(p4);
	}
	return 1;
}

string extract_tag_attribute(const string & name, const string & data)
{
	string r;
	extract_tag_attribute(r,name,data);
	return r;
}

void extract_tag_attribute(string & r, const string & name, const string & data)
{
	vector<string> words;
	string cstr;

	size_t i;
	int w;
	w=0;
	cstr.clear();
	for(i=0;i<data.length();i++)
	{
		char c=data[i];
		if (w==0 && !_isspace(c) && c!='=' && c!='\'' && c!='\"')
		{
			w=1;
			cstr=c;
		}
		else if (w==1 && !_isspace(c) && c!='=' && c!='\'' && c!='\"')
		{
			cstr+=c;
		}
		else if (w==0 && c=='\"')
		{
			w=2;
			cstr=c;
		}
		else if (w==2 && c=='\"')
		{
			w=0;
			cstr+=c;
			words.push_back(cstr);
			cstr.clear();
		}
		else if (w==0 && c=='\'')
		{
			w=3;
			cstr=c;
		}
		else if (w==3 && c=='\'')
		{
			w=0;
			cstr+=c;
			words.push_back(cstr);
			cstr.clear();
		}
		else if (w==2||w==3)
		{
			cstr+=c;
		}
		else if (w==1)
		{
			w=0;
			words.push_back(cstr);
			if (!_isspace(c))
			{
				cstr=c;
				words.push_back(cstr);
			}
			cstr.clear();
		}
		else if (!_isspace(c))
		{
			w=0;
			words.push_back(cstr);
			cstr=c;
			words.push_back(cstr);
			cstr.clear();
		}
	}
	if (!cstr.empty())
		words.push_back(cstr);

	for(i=0;i+2<words.size();i++)
	{
		if (words[i].compare(name)==0 && words[i+1].compare("=")==0)
			break;
	}
	if (i+2<words.size())
	{
		string &ret=r;
		ret=words[i+2];
		if (ret.length()>0 && (ret[0]=='\"' || ret[0]=='\''))
			ret=ret.substr(1);
		if (ret.length()>0 && (ret[ret.length()-1]=='\"' || ret[ret.length()-1]=='\''))
			ret=ret.substr(0,ret.length()-1);
		return;
	}
	r.clear();
}

string combine_tag(const string & tag, const map<string,string> & attr, const string & data)
{
	string r;
	combine_tag(r,tag,attr,data);
	return r;
}

void combine_tag(string & r, const string & tag, const map<string,string> & attr, const string & data)
{
	r.clear();
	r+='<';
	r+=tag;
	map<string,string>::const_iterator it;
	for(it=attr.begin();it!=attr.end();it++)
	{
		r+=' ';
		r+=it->first;
		r+="=\"";
		r+=it->second;
		r+='\"';
	}
	r+='>';
	r+=data;
	r+="</";
	r+=tag;
	r+='>';
	return;
}

XMLENC detect_ec(unsigned char * x)
{
	if (x[0]==0xff && x[1]==0xfe && x[2]==0 && x[3]==0)
		return EC_UTF32LE;
	if (x[0]==0 && x[1]==0 && x[2]==0xfe && x[3]==0xff)
		return EC_UTF32BE;
	if (x[0]==0xff && x[1]==0xfe)
		return EC_UTF16LE;
	if (x[0]==0xfe && x[1]==0xff)
		return EC_UTF16BE;
	if (x[0]==0xef && x[1]==0xbb && x[2]==0xbf)
		return EC_UTF8;
	return EC_DEFAULT;
}

XMLENC text_getbom(ifstream & fp, XMLENCREF encoding)
{
	long flen;
	unsigned char x[4];
	XMLENC ec;
	wstring data;
	if (!fp.is_open())
		return EC_AUTO;
	fp.seekg(0,ios::end);
	flen=fp.tellg();
	fp.seekg(0,ios::beg);
	int i;
	fp.read((char *)x,4);
	i=fp.gcount();
	for(;i<4;i++)
		x[i]=0x41;
	ec=detect_ec(x);
	if (ec==EC_UTF8)
		fp.seekg(3);
	else if (ec==EC_UTF16LE||ec==EC_UTF16BE)
		fp.seekg(2);
	else if (ec==EC_UTF32LE||ec==EC_UTF32BE)
		fp.seekg(4);
	else
		fp.seekg(0);
	if (ec==EC_DEFAULT && encoding!=EC_AUTO)
		ec=encoding;
	return ec;
}

wint_t text_getc(ifstream & fp, XMLENCREF encoding)
{
	wint_t w=WEOF;
	if (!fp.is_open())
		return WEOF;
	if (encoding==EC_AUTO)
		return WEOF;
	if (encoding==EC_DEFAULT)
		{
			locale loc("");
			char c[3];
			const char * pc;
			wchar_t x[3];
			wchar_t *px;
			mbstate_t state;
			int len;
			c[0]=fp.get();
			len=1;
			memset(&state,0,sizeof(state));
			use_facet<codecvt<wchar_t, char, mbstate_t> >(loc).in(state,
				c,c+len,pc,
				x,x+3,px);
			while (px==x)
			{
				c[1]=fp.get();
				len++;
				memset(&state,0,sizeof(state));
				if (use_facet<codecvt<wchar_t, char, mbstate_t> >(loc).in(state,
					c,c+len,pc,
					x,x+3,px)==codecvt_base::partial)
					break;
			}
			if (px!=x)
				w=*x;
		}
	else if (encoding==EC_UTF8)
		{
			char c[5];
			int second=0;
			c[0]=fp.get();
			if ((c[0]&0xc0)==0x80)
			{
				fp.seekg(-3,ios::cur);
				c[0]=fp.get();
				c[1]=fp.get();
				c[2]=fp.get();
				c[3]=fp.get();
				c[4]=0;
				second=1;
			}
			else if ((c[0]&0xf8)==0xf0)
			{
				c[1]=fp.get();
				long p=fp.tellg();
				c[2]=fp.get();
				c[3]=fp.get();
				c[4]=0;
				if (sizeof(wchar_t)==2)
					fp.seekg(p);
			}
			else if ((c[0]&0xf0)==0xe0)
			{
				c[1]=fp.get();
				c[2]=fp.get();
				c[3]=0;
			}
			else if ((c[0]&0xe0)==0xc0)
			{
				c[1]=fp.get();
				c[2]=0;
			}
			else
			{
				c[1]=0;
			}
			if (!fp.fail())
			{
				wstring x;
				u2w(x,c);
				if (!second && !x.empty())
					w=x[0];
				else if (second && x.length()>1)
					w=x[1];
			}
		}
	else if (encoding==EC_UTF16LE)
		{
			int c1,c2;
			c1=fp.get();
			c2=fp.get();
			if (c1!=EOF && c2!=EOF)
			{
				w=(c1&0xff)|((c2&0xff)<<8);
			}
			if (sizeof(wchar_t)>2 && (w&0xfc00)==0xd800)
			{
				unsigned short v1,v2;
				c1=fp.get();
				c2=fp.get();
				v1=w;
				v2=(c1&0xff)|((c2&0xff)<<8);
				w=((((v1&0x3ff)>>6)+1)<<16)
					|((v1&0x3f)<<10)
					|(v2&0x3ff);
			}
		}
	else if (encoding==EC_UTF16BE)
		{
			int c1,c2;
			c1=fp.get();
			c2=fp.get();
			if (c1!=EOF && c2!=EOF)
			{
				w=((c1&0xff)<<8)|(c2&0xff);
			}
			if (sizeof(wchar_t)>2 && (w&0xfc00)==0xd800)
			{
				unsigned short v1,v2;
				c1=fp.get();
				c2=fp.get();
				v1=w;
				v2=((c1&0xff)<<8)|(c2&0xff);
				w=((((v1&0x3ff)>>6)+1)<<16)
					|((v1&0x3f)<<10)
					|(v2&0x3ff);
			}
		}
	else if (encoding==EC_UTF32LE)
	{
		int c1,c2,c3,c4;
		bool half;
		half=fp.tellg()%4==2;
		if (half)
			fp.seekg(-2);
		c1=fp.get();
		c2=fp.get();
		c3=fp.get();
		c4=fp.get();
		if (c1!=EOF && c2!=EOF && c3!=EOF && c4!=EOF)
		{
			unsigned long x;
			x=(c1&0xff)|((c2&0xff)<<8)|((c3&0xff)<<16)|((c4&0xff)<<24);
			if (sizeof(wchar_t)==2 && x>0xffff)
			{
				if (half)
				{
					w=(wchar_t)(0xdc00|(x&0x3ff));
				}
				else
				{
					fp.seekg(-2);
					w=(wchar_t)(0xd800|((x&0xfc00)>>10)|((((x&0x1f0000)>>16)-1)<<6));
				}
			}
			else
				w=(wchar_t)x;
		}
	}
	else if (encoding==EC_UTF32BE)
	{
		int c1,c2,c3,c4;
		bool half;
		half=fp.tellg()%4==2;
		if (half)
			fp.seekg(-2);
		c1=fp.get();
		c2=fp.get();
		c3=fp.get();
		c4=fp.get();
		if (c1!=EOF && c2!=EOF && c3!=EOF && c4!=EOF)
		{
			unsigned long x;
			x=(c4&0xff)|((c3&0xff)<<8)|((c2&0xff)<<16)|((c1&0xff)<<24);
			if (sizeof(wchar_t)==2 && x>0xffff)
			{
				if (half)
				{
					w=0xdc00|((wchar_t)x&0x3ff);
				}
				else
				{
					fp.seekg(-2);
					w=0xd800|(((wchar_t)x&0xfc00)>>10)|(((((wchar_t)x&0x1f0000)>>16)-1)<<6);
				}
			}
			else
				w=(wchar_t)x;
		}
	}
	else if (encoding==EC_GB)
		{
			unsigned char c[3];
			c[0]=fp.get();
			if (c[0]>=0x81 && c[0]<=0xfe)
			{
				c[1]=fp.get();
				c[2]=0;
			}
			else
				c[1]=0;
			wstring x;
			loctow(x,(char *)c,EC_GB);
			if (!x.empty())
				w=x[0];
		}
	else if (encoding==EC_BIG5)
		{
			unsigned char c[3];
			c[0]=fp.get();
			if (c[0]>=0x81 && c[0]<=0xfe)
			{
				c[1]=fp.get();
				c[2]=0;
			}
			else
				c[1]=0;
			wstring x;
			loctow(x,(char *)c,EC_BIG5);
			if (!x.empty())
				w=x[0];
		}
	else if (encoding==EC_SJIS)
		{
			unsigned char c[3];
			c[0]=fp.get();
			if (c[0]>=0x81 && c[0]<=0x9f || c[0]>=0xe0 && c[0]<=0xfc)
			{
				c[1]=fp.get();
				c[2]=0;
			}
			else if (c[0]>=0xa0 && c[0]<=0xdf)
				c[1]=0;
			else
				c[1]=0;
			wstring x;
			loctow(x,(char *)c,EC_SJIS);
			if (!x.empty())
				w=x[0];
		}
	else if (encoding==EC_EUCJP)
		{
			unsigned char c[4];
			c[0]=fp.get();
			if (c[0]==0x8e || c[0]>=0xa1 && c[0]<=0xfe || c[0]==0x8f)
			{
				c[1]=fp.get();
				if (c[0]==0x8f)
				{
					c[2]=fp.get();
					c[3]=0;
				}
				else
					c[2]=0;
			}
			else
				c[1]=0;
			wstring x;
			loctow(x,(char *)c,EC_EUCJP);
			if (!x.empty())
				w=x[0];
		}
	else if (encoding==EC_EUCKR)
		{
			unsigned char c[3];
			c[0]=fp.get();
			if (c[0]>=0x81 && c[0]<=0xfe)
			{
				c[1]=fp.get();
				c[2]=0;
			}
			else
				c[1]=0;
			wstring x;
			loctow(x,(char *)c,EC_EUCKR);
			if (!x.empty())
				w=x[0];
		}
	else
		{
			unsigned char c[3];
			c[0]=fp.get();
			c[1]=0;
			wstring x;
			loctow(x,(char *)c,encoding);
			if (!x.empty())
				w=x[0];
		}
	return w;
}

wstring text_gets(ifstream & fp, XMLENCREF encoding)
{
	wstring r;
	text_gets(r,fp,encoding);
	return r;
}

void text_gets(wstring & r, ifstream & fp, XMLENCREF encoding)
{
	r.clear();
	if (!fp.is_open())
		return;
	if (encoding==EC_AUTO)
		return;
	wstring & s=r;
	s.clear();
	if (encoding==EC_DEFAULT)
		{
			string x;
			int c;
			x.clear();
			while ((c=fp.get())!=EOF)
			{
				if (c=='\r')
					continue;
				x+=c;
				if (c=='\n')
					break;
			}
			c2w(s,x);
		}
	else if (encoding==EC_UTF7)
		{
			string x;
			int c;
			x.clear();
			while ((c=fp.get())!=EOF)
			{
				if (c=='\r')
					continue;
				x+=c;
				if (c=='\n')
					break;
			}
			u7tow(s,x);
		}
	else if (encoding==EC_UTF8)
		{
			string x;
			int c;
			x.clear();
			while ((c=fp.get())!=EOF)
			{
				if (c=='\r')
					continue;
				x+=c;
				if (c=='\n')
					break;
			}
			u2w(s,x);
		}
	else if (encoding==EC_UTF16LE || encoding==EC_UTF16BE
		||encoding==EC_UTF32LE || encoding==EC_UTF32BE)
	{
		wint_t w;
		while (1)
		{
			w=text_getc(fp,encoding);
			if (w==WEOF)
				break;
			if (w=='\r')
				continue;
			s+=w;
			if (w=='\n')
				break;
		}
	}
	else
	{
		string x;
		int c;
		x.clear();
		while ((c=fp.get())!=EOF)
		{
			if (c=='\r')
				continue;
			x+=c;
			if (c=='\n')
				break;
		}
		loctow(s,x,encoding);
	}
	return;
}

size_t text_putbom(ofstream & fp, XMLENCREF encoding)
{
	int r=0;
	if (!fp.is_open())
		return 0;
	if (encoding==EC_AUTO)
		return 0;
	if (encoding==EC_UTF8)
	{
		fp.write("\xef\xbb\xbf",3);
		r=3;
	}
	else if (encoding==EC_UTF16LE)
	{
		fp.write("\xff\xfe",2);
		r=2;
	}
	else if (encoding==EC_UTF16BE)
	{
		fp.write("\xfe\xff",2);
		r=2;
	}
	else if (encoding==EC_UTF32LE)
	{
		fp.write("\xff\xfe\0\0",4);
		r=4;
	}
	else if (encoding==EC_UTF32BE)
	{
		fp.write("\0\0\xfe\xff",4);
		r=4;
	}
	else
	{
		r=0;
	}
	return r;
}

size_t text_putc(wint_t c, ofstream & fp, XMLENCREF encoding)
{
	size_t r=0;
	if (!fp.is_open())
		return 0;
	if (encoding==EC_AUTO)
		return 0;
	if (encoding==EC_UTF7)
		return 0;
	if (encoding==EC_DEFAULT)
		{
			string x;
			wstring y(L"");
			y+=(wchar_t)c;
			w2c(x,y);
			fp.write(x.c_str(),(streamsize)x.length());
			r=x.length();
		}
	else if (encoding==EC_UTF8)
		{
			string x;
			wstring y(L"");
			y+=(wchar_t)c;
			w2u(x,y);
			fp.write(x.c_str(),(streamsize)x.length());
			r=x.length();
		}
	else if (encoding==EC_UTF16LE)
	{
		if (c>>16)
		{
			fp.put(((((c>>16)-1)&3)<<6)|((c&0xfc00)>>10));
			fp.put(0xd8|(((c>>16)-1)>>2));
			fp.put(c&0xff);
			fp.put(0xdc|((c&0x300)>>8));
			r=4;
		}
		else
		{
			fp.put(c&0xff);
			fp.put((c>>8)&0xff);
			r=2;
		}
	}
	else if (encoding==EC_UTF16BE)
	{
		if (c>>16)
		{
			fp.put(0xd8|(((c>>16)-1)>>2));
			fp.put(((((c>>16)-1)&3)<<6)|((c&0xfc00)>>10));
			fp.put(0xdc|((c&0x300)>>8));
			fp.put(c&0xff);
			r=4;
		}
		else
		{
			fp.put((c>>8)&0xff);
			fp.put(c&0xff);
			r=2;
		}
	}
	else if (encoding==EC_UTF32LE)
	{
		if (c>>16)
		{
			fp.put(c&0xff);
			fp.put((c>>8)&0xff);
			fp.put((c>>16)&0xff);
			fp.put((c>>24)&0xff);
			r=4;
		}
		else
		{
			fp.put(c&0xff);
			fp.put((c>>8)&0xff);
			fp.put(0);
			fp.put(0);
			r=4;
		}
	}
	else if (encoding==EC_UTF32BE)
	{
		if (c>>16)
		{
			fp.put((c>>24)&0xff);
			fp.put((c>>16)&0xff);
			fp.put((c>>8)&0xff);
			fp.put(c&0xff);
			r=4;
		}
		else
		{
			fp.put(0);
			fp.put(0);
			fp.put((c>>8)&0xff);
			fp.put(c&0xff);
			r=4;
		}
	}
	else
	{
		string x;
		wstring y(L"");
		y+=(wchar_t)c;
		wtoloc(x,y,encoding);
		fp.write(x.c_str(),(streamsize)x.length());
		r=x.length();
	}
	return r;
}

size_t text_puts(const wstring & s, ofstream & fp, XMLENCREF encoding)
{
	size_t r=0;
	if (!fp.is_open())
		return 0;
	if (encoding==EC_AUTO)
		return 0;
	if (encoding==EC_DEFAULT)
		{
			string x;
			w2c(x,s);
			fp.write(x.c_str(),(streamsize)x.length());
			r=x.length();
		}
	else if (encoding==EC_UTF8)
		{
			string x;
			w2u(x,s);
			fp.write(x.c_str(),(streamsize)x.length());
			r=x.length();
		}
	else if (encoding==EC_UTF7)
		{
			string x;
			wtou7(x,s);
			fp.write(x.c_str(),(streamsize)x.length());
			r=x.length();
		}
	else if (encoding==EC_UTF16LE || encoding==EC_UTF16BE)
		{
			size_t i;
			size_t len;
			wchar_t c;
			len=s.length();
			for(i=0;i<len;i++)
			{
				c=s[i];
				r+=text_putc(c,fp,encoding);
			}
		}
	else if (encoding==EC_UTF32LE || encoding==EC_UTF32BE)
	{
		size_t i;
		size_t len;
		wchar_t c;
		len=s.length();
		for(i=0;i<len;i++)
		{
			c=s[i];
			if ((c&0xfc00)==0xd800 && i+1<len)
			{
				unsigned short c1,c2;
				unsigned long x;
				unsigned char y[4];
				c1=c;
				c2=s[i+1];
				x=(c2&0x3ff)|((c1&0x3f)<<10)|((((c1&0x3c0)>>6)+1)<<16);
				if (encoding==EC_UTF32LE)
				{
					y[0]=(unsigned char)(x&0xff);
					y[1]=(unsigned char)((x>>8)&0xff);
					y[2]=(unsigned char)((x>>16)&0xff);
					y[3]=(unsigned char)((x>>24)&0xff);
				}
				else
				{
					y[0]=(unsigned char)((x>>24)&0xff);
					y[1]=(unsigned char)((x>>16)&0xff);
					y[2]=(unsigned char)((x>>8)&0xff);
					y[3]=(unsigned char)(x&0xff);
				}
				fp.write((char *)y,4);
				r+=4;
				i++;
			}
			else
				r+=text_putc(c,fp,encoding);
		}
	}
	else
	{
		string x;
		wtoloc(x,s,encoding);
		fp.write(x.c_str(),(streamsize)x.length());
		r=x.length();
	}
	return r;
}

XMLENC detect_xml(/*const*/ char * data)
{
	int ret=0;
	char * p1, * p2;
	int u7;
	wstring tag;
	char * buf;
	p1=strstr(data,"<?");
	if (p1)
		p2=strstr(p1+2,"?>");
	else
		p2=NULL;
	u7=0;
	if (!p1 || !p2)
	{
		p1=strstr(data,"+ADw?");
		if (p1)
			p2=strstr(p1+4,"?+AD4");
		else
			p2=NULL;
		u7=1;
	}
	if (!p1 || !p2)
		return EC_DEFAULT;
	buf=new char[p2-p1];
	char * pp;
	int i;
	for(i=0,pp=p1+(u7?4:2);pp<p2;pp++,i++)
		buf[i]=*pp;
	buf[i]=0;
	if (u7)
		u7tow(tag,buf);
	else
		c2w(tag,buf);
	delete[] buf;
	string x;
	w2c(x,extract_tag_attribute(L"encoding",tag));

	for(i=0;i<sizeof(xmlenc)/sizeof(xmlenc[0]);i++)
	{
		if (stricmp(x.c_str(),xmlenc[i].name)==0)
			break;
	}
	if (i<sizeof(xmlenc)/sizeof(xmlenc[0]))
		return xmlenc[i].encoding;
	return x;
}

XMLENC readtextfile(const TCHAR * fn, wstring & data, XMLENCREF encoding, int isxml)
{
	ifstream fp;
	long flen;
	unsigned char x[4];
	XMLENC ec;
	data.clear();
	fp.open(t2c(fn).c_str(),ios::in|ios::binary);
	if (!fp.is_open())
		return EC_ERROR;
	fp.seekg(0,ios::end);
	flen=fp.tellg();
	fp.seekg(0,ios::beg);
	int i;
	fp.read((char *)x,4);
	i=fp.gcount();
	for(;i<4;i++)
		x[i]=0x41;
	ec=detect_ec(x);
	if (ec==EC_UTF16LE || ec==EC_UTF16BE || encoding==EC_UTF16LE || encoding==EC_UTF16BE)
	{
		unsigned char * buf;
		wchar_t * b2;
		int len;
		int skip=(ec==EC_UTF16LE || ec==EC_UTF16BE)?1:0;
		fp.seekg(skip*2,ios::beg);
		len=flen/2-skip;
		buf=new unsigned char[(len+1)*2];
		fp.read((char *)buf,len*2);
		buf[len*2]=0;
		buf[len*2+1]=0;
		b2=new wchar_t[len+1];
		int i,j;
		for(i=0,j=0;i<=len;i++,j++)
		{
			if (encoding==EC_UTF16BE || ec==EC_UTF16BE)
			{
				b2[j]=(buf[i*2]<<8)|(buf[i*2+1]);
				if (sizeof(wchar_t)>2 && (b2[i]&0xfc00)==0xd800)
				{
					unsigned short v1,v2;
					unsigned char c1,c2;
					c1=buf[i*2+2];
					c2=buf[i*2+3];
					v1=b2[i];
					v2=((c1&0xff)<<8)|(c2&0xff);
					b2[j]=((((v1&0x3ff)>>6)+1)<<16)
						|((v1&0x3f)<<10)
						|(v2&0x3ff);
					i++;
				}
			}
			else
			{
				b2[j]=(buf[i*2])|(buf[i*2+1]<<8);
				if (sizeof(wchar_t)>2 && (b2[i]&0xfc00)==0xd800)
				{
					unsigned short v1,v2;
					unsigned char c1,c2;
					c1=buf[i*2+2];
					c2=buf[i*2+3];
					v1=b2[i];
					v2=(c1&0xff)|((c2&0xff)<<8);
					b2[i]=((((v1&0x3ff)>>6)+1)<<16)
						|((v1&0x3f)<<10)
						|(v2&0x3ff);
					i++;
				}
			}
		}
		data=b2;
		delete[] b2;
		delete[] buf;
	}
	else
	if (ec==EC_UTF32LE || ec==EC_UTF32BE || encoding==EC_UTF32LE || encoding==EC_UTF32BE)
	{
		unsigned char * buf;
		wchar_t * b2;
		int len;
		int skip=(ec==EC_UTF32LE || ec==EC_UTF32BE)?1:0;
		fp.seekg(skip*4,ios::beg);
		len=flen/4-skip;
		buf=new unsigned char[(len+1)*4];
		fp.read((char *)buf,len*4);
		buf[len*4]=0;
		buf[len*4+1]=0;
		buf[len*4+2]=0;
		buf[len*4+3]=0;
		b2=new wchar_t[len*2+1];
		int i,j;
		for(i=0,j=0;i<len;i++)
		{
			unsigned long x;
			if (encoding==EC_UTF32BE || ec==EC_UTF32BE)
				x=(buf[i*4]<<24)|(buf[i*4+1]<<16)|(buf[i*4+2]<<8)|(buf[i*4+3]);
			else
				x=(buf[i*4+3]<<24)|(buf[i*4+2]<<16)|(buf[i*4+1]<<8)|(buf[i*4]);
			if (sizeof(wchar_t)==2 && x>0xffff)
			{
				b2[j++]=(wchar_t)(0xd800|((x&0xfc00)>>10)|((((x&0x1f0000)>>16)-1)<<6));
				b2[j++]=(wchar_t)(0xdc00|(x&0x3ff));
			}
			else
				b2[j++]=(wchar_t)x;
		}
		b2[j]=0;
		data=b2;
		delete[] b2;
		delete[] buf;
	}
	else
	{
		XMLENC xmlec;
		char * buf;
		buf=new char[flen+1];
		fp.seekg(ec==EC_UTF8?3:0,ios::beg);
		fp.read((char *)buf,flen-(ec==EC_UTF8?3:0));
		buf[flen-(ec==EC_UTF8?3:0)]=0;
		if (isxml)
			xmlec=detect_xml(buf);
		else
			xmlec=EC_DEFAULT;
		if (ec==EC_UTF8 || encoding==EC_UTF8 || xmlec==EC_UTF8)
			u2w(data,buf);
		else if (ec==EC_UTF7 || encoding==EC_UTF7 || xmlec==EC_UTF7)
			u7tow(data,buf);
		else if (ec!=EC_DEFAULT || encoding!=EC_DEFAULT && encoding!=EC_AUTO|| xmlec!=EC_DEFAULT)
		{
			XMLENC loc;
			loc=encoding;
			if (loc==EC_DEFAULT || loc==EC_AUTO)
				loc=xmlec;
			if (loc==EC_DEFAULT)
				loc=ec;
			loctow(data,buf,loc);
			ec=loc;
		}
		else
		{
			c2w(data,buf);
			ec="";
		}
		delete[] buf;
	}
	fp.close();
	return ec;
}

wstring extract_line(wstring & data)
{
	wstring r;
	extract_line(r,data);
	return r;
}

void extract_line(wstring & r, wstring & data)
{
	r.clear();
	size_t i;
	size_t len;
	len=data.length();
	for(i=0;i<len;i++)
	{
		wchar_t c=data[i];
		if (c=='\r')
			continue;
		r+=c;
		if (c=='\n')
			break;
	}
	if (i<len)
		data=data.substr(i+1);
	else
		data.clear();
}

int get_char(const wstring & data, size_t & r)
{
	int c;
	if (r>=data.length())
		return -1;
	c=data[r];
	r++;
	return c;
}

int extract_char(wstring & data)
{
	int c;
	size_t r;
	r=0;
	c=get_char(data,r);
	if (r>0)
		data=data.substr(r);
	return c;
}

size_t writetextfile(const TCHAR * fn, const wstring & str, XMLENCREF encoding)
{
	ofstream fp;
	fp.open(t2c(fn).c_str(),ios::out|ios::binary);
	if (!fp.is_open())
		return 0;
	if (encoding==EC_AUTO)
		encoding==EC_UTF16LE;
	size_t len;
	text_putbom(fp,encoding);
	len=text_puts(str,fp,encoding);
	return len;
}

XMLENC readtextfile(const TCHAR * fn, string & data, XMLENCREF encoding, int isxml)
{
	ifstream fp;
	long flen;
	unsigned char x[4];
	XMLENC ec;
	data.clear();
	fp.open(t2c(fn).c_str(),ios::in|ios::binary);
	if (!fp.is_open())
		return EC_ERROR;
	fp.seekg(0,ios::end);
	flen=fp.tellg();
	fp.seekg(0,ios::beg);
	int i;
	fp.read((char *)x,4);
	i=fp.gcount();
	for(;i<4;i++)
		x[i]=0x41;
	ec=detect_ec(x);
	if (ec==EC_UTF16LE || ec==EC_UTF16BE || encoding==EC_UTF16LE || encoding==EC_UTF16BE)
	{
		unsigned char * buf;
		char * b2;
		int len;
		int skip=(ec==EC_UTF16LE || ec==EC_UTF16BE)?1:0;
		fp.seekg(skip*2,ios::beg);
		len=flen/2-skip;
		buf=new unsigned char[(len+1)*2];
		fp.read((char *)buf,len*2);
		buf[len*2]=0;
		buf[len*2+1]=0;
		b2=new char[len*3+1];
		int i,j;
		for(i=0,j=0;i<len;i++)
		{
			unsigned long x;
			if (encoding==EC_UTF16BE || ec==EC_UTF16BE)
			{
				unsigned short x1;
				x1=(buf[i*2]<<8)|(buf[i*2+1]);
				if ((x1&0xfc00)==0xd800)
				{
					unsigned short x2;
					x2=(buf[i*2+2]<<8)|(buf[i*2+3]);
					i++;
					x=((((x1&0x3c0)>>6)+1)<<16)|((x1&0x3f)<<10)|(x2&0x3ff);
				}
				else
					x=x1;
			}
			else
			{
				unsigned short x1;
				x1=(buf[i*2+1]<<8)|(buf[i*2]);
				if ((x1&0xfc00)==0xd800)
				{
					unsigned short x2;
					x2=(buf[i*2+3]<<8)|(buf[i*2+2]);
					i++;
					x=((((x1&0x3c0)>>6)+1)<<16)|((x1&0x3f)<<10)|(x2&0x3ff);
				}
				else
					x=x1;
			}
			if (x<0x80)
			{
				b2[j++]=(unsigned char)x;
			}
			else if (x<0x800)
			{
				b2[j++]=0xc0|(unsigned char)((x&0x7c0)>>6);
				b2[j++]=0x80|(unsigned char)(x&0x3f);
			}
			else if (x<0x10000)
			{
				b2[j++]=0xe0|(unsigned char)((x&0xf000)>>12);
				b2[j++]=0x80|(unsigned char)((x&0xfc0)>>6);
				b2[j++]=0x80|(unsigned char)(x&0x3f);
			}
			else
			{
				b2[j++]=0xf0|(unsigned char)((x&0x1c0000)>>18);
				b2[j++]=0x80|(unsigned char)((x&0x3f000)>>12);
				b2[j++]=0x80|(unsigned char)((x&0xfc0)>>6);
				b2[j++]=0x80|(unsigned char)(x&0x3f);
			}
		}
		b2[j]=0;
		data=b2;
		delete[] b2;
		delete[] buf;
	}
	else
		if (ec==EC_UTF32LE || ec==EC_UTF32BE || encoding==EC_UTF32LE || encoding==EC_UTF32BE)
		{
			unsigned char * buf;
			char * b2;
			int len;
			int skip=(ec==EC_UTF32LE || ec==EC_UTF32BE)?1:0;
			fp.seekg(skip*4,ios::beg);
			len=flen/4-skip;
			buf=new unsigned char[(len+1)*4];
			fp.read((char *)buf,len*4);
			buf[len*4]=0;
			buf[len*4+1]=0;
			buf[len*4+2]=0;
			buf[len*4+3]=0;
			b2=new char[len*4+1];
			int i,j;
			for(i=0,j=0;i<len;i++)
			{
				unsigned long x;
				if (encoding==EC_UTF32BE || ec==EC_UTF32BE)
					x=(buf[i*4]<<24)|(buf[i*4+1]<<16)|(buf[i*4+2]<<8)|(buf[i*4+3]);
				else
					x=(buf[i*4+3]<<24)|(buf[i*4+2]<<16)|(buf[i*4+1]<<8)|(buf[i*4]);
				if (x<0x80)
				{
					b2[j++]=(unsigned char)x;
				}
				else if (x<0x800)
				{
					b2[j++]=0xc0|(unsigned char)((x&0x7c0)>>6);
					b2[j++]=0x80|(unsigned char)(x&0x3f);
				}
				else if (x<0x10000)
				{
					b2[j++]=0xe0|(unsigned char)((x&0xf000)>>12);
					b2[j++]=0x80|(unsigned char)((x&0xfc0)>>6);
					b2[j++]=0x80|(unsigned char)(x&0x3f);
				}
				else
				{
					b2[j++]=0xf0|(unsigned char)((x&0x1c0000)>>18);
					b2[j++]=0x80|(unsigned char)((x&0x3f000)>>12);
					b2[j++]=0x80|(unsigned char)((x&0xfc0)>>6);
					b2[j++]=0x80|(unsigned char)(x&0x3f);
				}
			}
			b2[j]=0;
			data=b2;
			delete[] b2;
			delete[] buf;
		}
		else
		{
			XMLENC xmlec;
			char * buf;
			buf=new char[flen+1];
			fp.seekg(ec==EC_UTF8?3:0,ios::beg);
			fp.read((char *)buf,flen-(ec==EC_UTF8?3:0));
			buf[flen-(ec==EC_UTF8?3:0)]=0;
			if (isxml)
				xmlec=detect_xml(buf);
			else
				xmlec=EC_DEFAULT;
			if (ec==EC_UTF8 || encoding==EC_UTF8 || xmlec==EC_UTF8)
				data=buf;
			else if (ec==EC_UTF7 || encoding==EC_UTF7 || xmlec==EC_UTF7)
				u7tou(data,buf);
			else if (ec!=EC_DEFAULT || encoding!=EC_DEFAULT && encoding!=EC_AUTO|| xmlec!=EC_DEFAULT)
			{
				XMLENC loc;
				loc=encoding;
				if (loc==EC_DEFAULT || loc==EC_AUTO)
					loc=xmlec;
				if (loc==EC_DEFAULT)
					loc=ec;
				loctou(data,buf,loc);
				ec=loc;
			}
			else
			{
				c2u(data,buf);
				ec="";
			}
			delete[] buf;
		}
		fp.close();
		return ec;
}

string extract_line(string & data)
{
	string r;
	extract_line(r,data);
	return r;
}

void extract_line(string & r, string & data)
{
	r.clear();
	size_t i;
	size_t len;
	len=data.length();
	for(i=0;i<len;i++)
	{
		char c=data[i];
		if (c=='\r')
			continue;
		r+=c;
		if (c=='\n')
			break;
	}
	if (i<len)
		data=data.substr(i+1);
	else
		data.clear();
}

int get_char(const string & data, size_t & p)
{
	wchar_t c;
	size_t dlen;
	dlen=data.length();
	if (p>=dlen)
		return -1;
	c=data[p];
	p++;
	if ((c&0x80)==0)
	{
	}
	else if ((c&0xe0)==0xc0)
	{
		if (p<dlen)
		{
			c=((c&0x1f)<<6)|(data[p]&0x3f);
			p++;
		}
	}
	else if ((c&0xf0)==0xe0)
	{
		if (p+1<dlen)
		{
			c=((c&0xf)<<12)|((data[p]&0x3f)<<6)|(data[p+1]&0x3f);
			p+=2;
		}
	}
	else if ((c&0xf8)==0xf0)
	{
		if (p+2<dlen)
		{
			c=((c&0x7)<<18)|((data[p]&0x3f)<<12)|((data[p+1]&0x3f)<<6)|(data[p+2]&0x3f);
			p+=3;
		}
	}
	return c;
}

int extract_char(string & data)
{
	int c;
	size_t r;
	r=0;
	c=get_char(data,r);
	if (r>0)
		data=data.substr(r);
	return c;
}

size_t writetextfile(const TCHAR * fn, const string & str, XMLENCREF encoding)
{
	ofstream fp;
	fp.open(t2c(fn).c_str(),ios::out|ios::binary);
	if (!fp.is_open())
		return 0;
	if (encoding==EC_AUTO)
		encoding==EC_UTF16LE;
	size_t len;
	text_putbom(fp,encoding);
	wstring data;
	u2w(data,str);
	len=text_puts(data,fp,encoding);
	return len;
}

wstring remove_ref(const wstring & str)
{
	wstring r;
	remove_ref(r,str);
	return r;
}

void remove_ref(wstring & r, const wstring & str)
{
	wstring &x=r;
	x=str;
	size_t p;
	p=x.npos;
	do
	{
		p=x.find(L"&amp;",p+1);
		if (p!=x.npos)
			x.replace(p,5,L"&");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find(L"&gt;",p+1);
		if (p!=x.npos)
			x.replace(p,4,L">");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find(L"&lt;",p+1);
		if (p!=x.npos)
			x.replace(p,4,L"<");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find(L"&apos;",p+1);
		if (p!=x.npos)
			x.replace(p,5,L"\'");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find(L"&quot;",p+1);
		if (p!=x.npos)
			x.replace(p,5,L"\"");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find(L"&#",p+1);
		if (p!=x.npos)
		{
			size_t q;
			q=x.find(';',p+1);
			if (q!=x.npos)
			{
				wstring v;
				v=x.substr(p+2,q-p-2);
				if (!v.empty())
				{
					wchar_t xx[2];
					if (v[0]=='x' || v[0]=='X')
						xx[0]=(wchar_t)wcstol(v.substr(1).c_str(),NULL,16);
					else
						xx[0]=(wchar_t)wcstol(v.c_str(),NULL,10);
					xx[1]=0;
					x.replace(p,q-p+1,xx);
				}
			}
		}
	} while (p!=x.npos);
	return;
}

wstring replace_ref(const wstring & str)
{
	wstring r;
	replace_ref(r,str);
	return r;
}

void replace_ref(wstring & r, const wstring & str)
{
	wstring & x=r;
	x=str;
	size_t p;
	p=x.npos;
	do
	{
		p=x.find('&',p+1);
		if (p!=x.npos)
			x.replace(p,1,L"&amp;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('<',p+1);
		if (p!=x.npos)
			x.replace(p,1,L"&lt;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('>',p+1);
		if (p!=x.npos)
			x.replace(p,1,L"&gt;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('\'',p+1);
		if (p!=x.npos)
			x.replace(p,1,L"&apos;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('"',p+1);
		if (p!=x.npos)
			x.replace(p,1,L"&quot;");
	} while (p!=x.npos);
	return;
}

string remove_ref(const string & str)
{
	string r;
	remove_ref(r,str);
	return r;
}

void remove_ref(string & r, const string & str)
{
	string &x=r;
	x=str;
	size_t p;
	p=x.npos;
	do
	{
		p=x.find("&amp;",p+1);
		if (p!=x.npos)
			x.replace(p,5,"&");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find("&gt;",p+1);
		if (p!=x.npos)
			x.replace(p,4,">");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find("&lt;",p+1);
		if (p!=x.npos)
			x.replace(p,4,"<");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find("&apos;",p+1);
		if (p!=x.npos)
			x.replace(p,5,"\'");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find("&quot;",p+1);
		if (p!=x.npos)
			x.replace(p,5,"\"");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find("&#",p+1);
		if (p!=x.npos)
		{
			size_t q;
			q=x.find(';',p+1);
			if (q!=x.npos)
			{
				string v;
				v=x.substr(p+2,q-p-2);
				if (!v.empty())
				{
					char xx[2];
					if (v[0]=='x' || v[0]=='X')
						xx[0]=(char)strtol(v.substr(1).c_str(),NULL,16);
					else
						xx[0]=(char)strtol(v.c_str(),NULL,10);
					xx[1]=0;
					x.replace(p,q-p+1,xx);
				}
			}
		}
	} while (p!=x.npos);
	return;
}

string replace_ref(const string & str)
{
	string r;
	replace_ref(r,str);
	return r;
}

void replace_ref(string & r, const string & str)
{
	string & x=r;
	x=str;
	size_t p;
	p=x.npos;
	do
	{
		p=x.find('&',p+1);
		if (p!=x.npos)
			x.replace(p,1,"&amp;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('<',p+1);
		if (p!=x.npos)
			x.replace(p,1,"&lt;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('>',p+1);
		if (p!=x.npos)
			x.replace(p,1,"&gt;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('\'',p+1);
		if (p!=x.npos)
			x.replace(p,1,"&apos;");
	} while (p!=x.npos);
	p=x.npos;
	do
	{
		p=x.find('"',p+1);
		if (p!=x.npos)
			x.replace(p,1,"&quot;");
	} while (p!=x.npos);
	return;
}

wstring trimall(const wstring & str)
{
	wstring r;
	trimall(r,str);
	return r;
}

void trimall(wstring & ret, const wstring & str)
{
	size_t len;
	size_t l,r;
	ret.clear();
	len=str.length();
	if (len==0)
		return;
	for(l=0;l<len;l++)
		if (!_isspace(str[l]))
			break;
	for(r=len-1;r>=l && r!=0-1;r--)
		if (!_isspace(str[r]))
			break;
	if (l<=r)
		ret=str.substr(l,r-l+1);
	return;
}

wstring rtrim(const wstring & str)
{
	wstring r;
	rtrim(r,str);
	return r;
}

void rtrim(wstring & ret, const wstring & str)
{
	size_t len;
	size_t r;
	ret.clear();
	len=str.length();
	if (len==0)
		return;
	for(r=len-1;r>=0 && r!=0-1;r--)
		if (!_isspace(str[r]))
			break;
	ret=str.substr(0,r+1);
}

wstring ltrim(const wstring & str)
{
	wstring r;
	ltrim(r,str);
	return r;
}

void ltrim(wstring & ret, const wstring & str)
{
	size_t len;
	size_t l;
	ret.clear();
	len=str.length();
	if (len==0)
		return;
	for(l=0;l<len;l++)
		if (!_isspace(str[l]))
			break;
	ret=str.substr(l,len-l);
}

string trimall(const string & str)
{
	string r;
	trimall(r,str);
	return r;
}

void trimall(string & ret, const string & str)
{
	size_t len;
	size_t l,r;
	ret.clear();
	len=str.length();
	if (len==0)
		return;
	for(l=0;l<len;l++)
		if (!_isspace(str[l]))
			break;
	for(r=len-1;r>=l && r!=0-1;r--)
		if (!_isspace(str[r]))
			break;
	if (l<=r)
		ret=str.substr(l,r-l+1);
	return;
}

string rtrim(const string & str)
{
	string r;
	rtrim(r,str);
	return r;
}

void rtrim(string & ret, const string & str)
{
	size_t len;
	size_t r;
	ret.clear();
	len=str.length();
	if (len==0)
		return;
	for(r=len-1;r>=0 && r!=0-1;r--)
		if (!_isspace(str[r]))
			break;
	ret=str.substr(0,r+1);
}

string ltrim(const string & str)
{
	string r;
	ltrim(r,str);
	return r;
}

void ltrim(string & ret, const string & str)
{
	size_t len;
	size_t l;
	ret.clear();
	len=str.length();
	if (len==0)
		return;
	for(l=0;l<len;l++)
		if (!_isspace(str[l]))
			break;
	ret=str.substr(l,len-l);
}

static inline size_t _read_in_tag(const wstring & data, size_t len, size_t f)
{
	wchar_t c;
	c=data[f];
	if (c=='\"'
		||c=='\'')
	{
		f++;
		while (f<len && data[f]!=c)
			f++;
		if (f<len)
			f++;
	}
	else
		f++;
	return f;
}

XMLENC xml_load(const TCHAR * fn, XMLDOC & doc)
{
	wstring data;
	XMLENC ec;

	ec=readtextfile(fn,data,EC_AUTO,1);

	xml_load_str(data,doc);

	return ec;
}

int xml_load_str(const wstring & str, XMLDOC & doc)
{
	const wstring & data=str;
	vector<vector<XMLNODE>::reverse_iterator> parents;
	doc.clear();

	size_t i;
	size_t len;
	len=data.length();

	wstring w;
	size_t j;

	parents.clear();
	i=0;
	while (i<len)
	{
		j=i;
		while (j<len && data[j]!='<')
			j++;
		w=data.substr(i,j-i);
		if (!w.empty())
		{
			// a text node
			XMLNODE n;
			n.type=XN_TEXT;
			n.data=w;
			n.tag.clear();
			n.attrs.clear();
			n.childs.clear();
			if (!parents.empty())
				(*parents.rbegin())->childs.push_back(n);
			else
				doc.push_back(n);
		}
		i=j;
		if (i>=len)
			break;
		if (j+1<len && data[j+1]=='?')
		{
			// process instruction
			j+=2;
			while (j<len && (data[j]!='?' || (j+1<len && data[j+1]!='>')))
			{
				j=_read_in_tag(data,len,j);
			}
			if (j<len)
				j+=2;
			w=data.substr(i,j-i);
			wstring tagname;

			size_t b,k;
			size_t wlen;
			wlen=w.length();
			b=2;
			k=b;
			while (k<wlen && (!_isspace(w[k]))
				&& w[k]!='>'
				&& w[k]!='/'
				&& w[k]!='?')
				k++;
			tagname=w.substr(b,k-b);

			size_t v;
			v=wlen;
			if (v>0 && w[v-1]=='>')
			{
				v--;
				if (v>0 && w[v-1]=='?')
					v--;
			}
			wstring d;
			if (v>k+1)
				d=w.substr(k+1,v-k-1);
			else
				d.clear();

			size_t p1,p2,p3,p4,p5;
			size_t dlen;
			vector<XMLATTR> attrs;
			wstring name,attr;
			dlen=d.length();
			p1=0;
			while (p1<dlen)
			{
				while (p1<dlen && _isspace(d[p1]))
					p1++;
				p2=p1;
				while (p2<dlen && !_isspace(d[p2]) && d[p2]!='=')
					p2++;
				name=d.substr(p1,p2-p1);
				p3=p2;
				while (p3<dlen && _isspace(d[p3]))
					p3++;
				if (p3<dlen && d[p3]=='=')
				{
					p4=p3+1;
					while (p4<dlen && _isspace(d[p4]))
						p4++;
					if (p4<dlen && (d[p4]=='\"' || d[p4]=='\''))
					{
						wchar_t c=d[p4];
						p5=p4+1;
						while (p5<dlen && d[p5]!=c)
							p5++;
						p5++;
						attr=d.substr(p4+1,p5-p4-2);
					}
					else
					{
						p5=p4;
						while (p5<dlen && !_isspace(d[p5]))
							p5++;
						attr=d.substr(p4,p5-p4);
					}
					if (!name.empty())
						attrs.push_back(XMLATTR(name,attr));
					p1=p5;
				}
				else
					p1=p3;
			}

			XMLNODE n;
			n.type=XN_PROCESS_INST;
			n.tag=tagname;
			n.data=d;
			n.attrs=attrs;
			n.childs.clear();
			if (!parents.empty())
				(*parents.rbegin())->childs.push_back(n);
			else
				doc.push_back(n);
		}
		else if (j+3<len 
			&& data[j+1]=='!'
			&& data[j+2]=='-'
			&& data[j+3]=='-')
		{
			// comment
			j+=4;
			while (j<len && (data[j]!='-' 
				|| (j+1<len && data[j+1]!='-')
				|| (j+2<len && data[j+2]!='>')))
			{
				j++;
			}
			if (j<len)
				j+=3;
			w=data.substr(i,j-i);
			size_t k;
			size_t wlen;

			wlen=w.length();

			k=4;

			size_t v;
			v=wlen;
			if (v>0 && w[v-1]=='>')
			{
				v--;
				if (v>0 && w[v-1]=='-')
				{
					v--;
					if (v>0 && w[v-1]=='-')
						v--;
				}
			}
			wstring d;
			if (v>k)
				d=w.substr(k,v-k);

			XMLNODE n;
			n.type=XN_COMMENT;
			n.data=d;
			n.tag.clear();
			n.attrs.clear();
			n.childs.clear();
			if (!parents.empty())
				(*parents.rbegin())->childs.push_back(n);
			else
				doc.push_back(n);
		}
		else if (j+8<len
			&& data[j+1]=='!'
			&& data[j+2]=='['
			&& data[j+3]=='C'
			&& data[j+4]=='D'
			&& data[j+5]=='A'
			&& data[j+6]=='T'
			&& data[j+7]=='A'
			&& data[j+8]=='[')
		{
			// cdata
			j+=9;
			while (j<len && (data[j]!=']' 
				|| (j+1<len && data[j+1]!=']')
				|| (j+2<len && data[j+2]!='>')))
			{
				j++;
			}
			if (j<len)
				j+=3;
			w=data.substr(i,j-i);
			size_t k;
			size_t wlen;

			wlen=w.length();

			k=9;

			size_t v;
			v=wlen;
			if (v>0 && w[v-1]=='>')
			{
				v--;
				if (v>0 && w[v-1]==']')
				{
					v--;
					if (v>0 && w[v-1]==']')
						v--;
				}
			}
			wstring d;
			if (v>k)
				d=w.substr(k,v-k);
			else
				d.clear();
			XMLNODE n;
			n.type=XN_CDATA;
			n.data=d;
			n.tag.clear();
			n.attrs.clear();
			n.childs.clear();
			if (!parents.empty())
				(*parents.rbegin())->childs.push_back(n);
			else
				doc.push_back(n);
		}
		else if (j+8<len
			&& data[j+1]=='!'
			&& data[j+2]=='D'
			&& data[j+3]=='O'
			&& data[j+4]=='C'
			&& data[j+5]=='T'
			&& data[j+6]=='Y'
			&& data[j+7]=='P'
			&& data[j+8]=='E')
		{
			// cdata
			j+=9;
			int level;
			level=0;
			while (j<len && (level!=0 || data[j]!='>'))
			{
				if (data[j]=='<')
					level++;
				if (data[j]=='>')
					level--;
				j=_read_in_tag(data,len,j);
			}
			if (j<len)
				j++;
			w=data.substr(i,j-i);
			size_t k;
			size_t wlen;

			wlen=w.length();

			k=9;

			size_t v;
			v=wlen;
			if (v>0 && w[v-1]=='>')
			{
				v--;
			}
			wstring d;
			if (v>k)
				d=w.substr(k,v-k);
			else
				d.clear();

			XMLNODE n;
			n.type=XN_DOCTYPE;
			n.data=d;
			n.tag.clear();
			n.attrs.clear();
			n.childs.clear();
			if (!parents.empty())
				(*parents.rbegin())->childs.push_back(n);
			else
				doc.push_back(n);
		}
		else
		{
			while (j<len && data[j]!='>')
			{
				j=_read_in_tag(data,len,j);
				// a new node
			}
			if (j<len)
				j++;
			w=data.substr(i,j-i);
			wstring tagname;

			size_t b,k;
			size_t wlen;
			bool fo,fc;
			wlen=w.length();
			if (wlen>0 && w[1]=='/')
			{
				b=2;
				fo=false;
				fc=true;
			}
			else
			{
				b=1;
				fo=true;
				fc=false;
			}
			k=b;
			while (k<wlen && (!_isspace(w[k]))
				&& w[k]!='>'
				&& w[k]!='/')
				k++;
			tagname=w.substr(b,k-b);
			if (wlen>2 && w[wlen-2]=='/')
			{
				fc=true;
			}
			size_t v;
			v=wlen;
			if (v>0 && w[v-1]=='>')
			{
				v--;
				if (v>0 && w[v-1]=='/')
					v--;
			}
			wstring d;
			if (v>k+1)
				d=w.substr(k+1,v-k-1);
			else
				d.clear();

			size_t p1,p2,p3,p4,p5;
			size_t dlen;
			vector<XMLATTR> attrs;
			wstring name,attr;
			dlen=d.length();
			p1=0;
			while (p1<dlen)
			{
				while (p1<dlen && _isspace(d[p1]))
					p1++;
				p2=p1;
				while (p2<dlen && !_isspace(d[p2]) && d[p2]!='=')
					p2++;
				name=d.substr(p1,p2-p1);
				p3=p2;
				while (p3<dlen && _isspace(d[p3]))
					p3++;
				if (p3<dlen && d[p3]=='=')
				{
					p4=p3+1;
					while (p4<dlen && _isspace(d[p4]))
						p4++;
					if (p4<dlen && (d[p4]=='\"' || d[p4]=='\''))
					{
						wchar_t c=d[p4];
						p5=p4+1;
						while (p5<dlen && d[p5]!=c)
							p5++;
						p5++;
						attr=d.substr(p4+1,p5-p4-2);
					}
					else
					{
						p5=p4;
						while (p5<dlen && !_isspace(d[p5]))
							p5++;
						attr=d.substr(p4,p5-p4);
					}
					if (!name.empty())
						attrs.push_back(XMLATTR(name,attr));
					p1=p5;
				}
				else
					p1=p3;
			}

			XMLNODE n;
			n.type=XN_ELEMENT;
			n.tag=tagname;
			n.data=d;
			n.attrs=attrs;
			n.childs.clear();

			if (fo)
			{
				if (!parents.empty())
					(*parents.rbegin())->childs.push_back(n);
				else
					doc.push_back(n);
				if (!fc)
				{
					if (!parents.empty())
						parents.push_back((*parents.rbegin())->childs.rbegin());
					else
						parents.push_back(doc.rbegin());
				}			
			}
			else if (fc)
			{
				if (!parents.empty())
					parents.pop_back();
			}
		}
		i=j;
	}
	//	ce=clock();
	//	cout<<"process ok..."<<setprecision(4)<<(double)(ce-cb)/CLOCKS_PER_SEC<<" second(s)"<<endl;
	//	cin>> ce;
	return 0;
}

static wstring _replace_rn(const wstring & str)
{
	wstring xx;
	xx.clear();
	size_t i;
	size_t slen;
	slen=str.length();
	for(i=0;i<slen;i++)
	{
		if (str[i]=='\r')
			xx+=L"\\r";
		else if (str[i]=='\n')
			xx+=L"\\n";
		else if (str[i]=='\t')
			xx+=L"\\t";
		else
			xx+=str[i];
	}
	return xx;
}

static inline void _save_attrs(wstring & data, const vector<XMLATTR> & attrs)
{
	size_t i;
	size_t anum;
	anum=attrs.size();
	for(i=0;i<anum;i++)
	{
		bool cd,cs;
		const wstring & value=attrs[i].value;
		data+=(i==0?L"":L" ")+attrs[i].name+L"=";
		size_t i;
		size_t slen;
		slen=value.length();
		cd=false;
		cs=false;
		for(i=0;i<slen;i++)
		{
			if (value[i]=='\"')
				cd=true;
			if (value[i]=='\'')
				cs=true;
			if (cs && cd)
				break;
		}
		if (cs && cd)
		{
			size_t p;
			wstring x;
			x=value;
			p=x.npos;
			do
			{
				p=x.find('\"',p+1);
				if (p!=x.npos)
					x.replace(p,1,L"&quot;");
			} while (p!=x.npos);
			cd=false;
		}
		if (cd)
			data+=L"\'"+value+L"\'";
		else
			data+=L"\""+value+L"\"";
	}
}

size_t xml_save(const TCHAR * fn, const XMLDOC & doc, XMLENCREF encoding)
{
	wstring data;
	xml_save_str(data,doc);
	return writetextfile(fn,data,encoding);
}

wstring xml_save_str(const XMLDOC & doc)
{
	wstring r;
	xml_save_str(r,doc);
	return r;
}

void xml_save_str(wstring & str, const XMLDOC & doc)
{
	str.clear();
	wstring data;

	vector<vector<XMLNODE>::const_iterator> parents;
	parents.clear();

	vector<XMLNODE>::const_iterator cur;
	const vector<XMLNODE> * dd;
	//	int level=0;
	//	int i;
	dd=NULL;
	while (1)
	{
		if (dd==NULL)
		{
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur=dd->begin();
		}
		while (!cur->childs.empty())
		{
			switch(cur->type)
			{
			case XN_ELEMENT:
				data=L"<";
				data+=cur->tag;
				if (!cur->attrs.empty())
				{
					data+=L" ";
					_save_attrs(data,cur->attrs);
				}
				data+=L">";
				str+=data;
				break;
			}
			parents.push_back(cur);
			dd=&cur->childs;
			cur=cur->childs.begin();
		}
		switch(cur->type)
		{
		case XN_ELEMENT:
			data=L"<";
			data+=cur->tag;
			if (!cur->attrs.empty())
			{
				data+=L" ";
				_save_attrs(data,cur->attrs);
			}
			data+=L"/>";
			str+=data;
			break;
		case XN_PROCESS_INST:
			data=L"<?";
			data+=cur->tag;
			if (!cur->attrs.empty())
			{
				data+=L" ";
				_save_attrs(data,cur->attrs);
			}
			data+=L"?>";
			str+=data;
			break;
		case XN_TEXT:
			data=cur->data;
			str+=data;
			break;
		case XN_CDATA:
			data=L"<![CDATA[";
			data+=cur->data;
			data+=L"]]>";
			str+=data;
			break;
		case XN_DOCTYPE:
			data=L"<!DOCTYPE";
			data+=cur->data;
			data+=L">";
			str+=data;
			break;
		case XN_COMMENT:
			data=L"<!--";
			data+=cur->data;
			data+=L"-->";
			str+=data;
			break;
		}
		cur++;
		while (cur==dd->end() && !parents.empty())
		{
			cur=*parents.rbegin();
			parents.pop_back();
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;

			//			level--;
			//			for(i=0;i<level;i++)
			//				cout<<"  ";
			//			cout<<"END<"<<w2c(cur->tag)<<">"<<endl;
			switch(cur->type)
			{
			case XN_ELEMENT:
				data=L"</"+cur->tag+L">";
				str+=data;
				break;
			}

			cur++;
		}
		if (cur==dd->end() && parents.empty())
			break;
	}
}

void xml_display(ostream & os, const XMLDOC & doc)
{
	vector<vector<XMLNODE>::const_iterator> parents;
	parents.clear();

	vector<XMLNODE>::const_iterator cur;
	const vector<XMLNODE> * dd;
	int level=0;
	int i;
	dd=NULL;
	while (1)
	{
		if (dd==NULL)
		{
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur=dd->begin();
		}
		while (!cur->childs.empty())
		{
			for(i=0;i<level;i++)
				os<<"  ";
			os<<"BEGIN<"<<w2c(cur->tag)<<">: ";
			if (!cur->attrs.empty())
			{
				wstring s;
				_save_attrs(s,cur->attrs);
				os<<w2c(s);
			}
			os<<endl;
			level++;
			parents.push_back(cur);
			dd=&cur->childs;
			cur=cur->childs.begin();
		}
		for(i=0;i<level;i++)
			os<<"  ";
		switch(cur->type)
		{
		case XN_ELEMENT:
			os<<"BEGIN<"<<w2c(cur->tag)<<">: ";
			if (!cur->attrs.empty())
			{
				wstring s;
				_save_attrs(s,cur->attrs);
				os<<w2c(s);
			}
			os<<endl;
			for(i=0;i<level;i++)
				os<<"  ";
			os<<"END<"<<w2c(cur->tag)<<">"<<endl;
			break;
		case XN_PROCESS_INST:
			os<<"PI<"<<w2c(cur->tag)<<">: ";
			if (!cur->attrs.empty())
			{
				wstring s;
				_save_attrs(s,cur->attrs);
				os<<w2c(s);
			}
			os<<endl;
			break;
		case XN_TEXT:
			os<<"TEXT: ";
			os<<w2c(_replace_rn(cur->data))<<endl;
			break;
		case XN_CDATA:
			os<<"CDATA: ";
			os<<w2c(_replace_rn(cur->data))<<endl;
			break;
		case XN_DOCTYPE:
			os<<"DOCTYPE: ";
			os<<w2c(_replace_rn(cur->data))<<endl;
			break;
		case XN_COMMENT:
			os<<"COMMENT: ";
			os<<w2c(_replace_rn(cur->data))<<endl;
			break;
		}
		cur++;
		while (cur==dd->end() && !parents.empty())
		{
			cur=*parents.rbegin();
			parents.pop_back();
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;

			level--;
			for(i=0;i<level;i++)
				os<<"  ";
			os<<"END<"<<w2c(cur->tag)<<">"<<endl;
			cur++;
		}
		if (cur==dd->end() && parents.empty())
			break;
	}
}

XMLNODELIST xml_enum_elements(XMLNODE & doc, const wstring & tag)
{
	return xml_enum_elements(doc.childs,tag);
}

XMLCONSTNODELIST xml_enum_elements(const XMLNODE & doc, const wstring & tag)
{
	return xml_enum_elements(doc.childs,tag);
}

XMLNODELIST xml_enum_elements(XMLDOC & doc, const wstring & tag)
{
	XMLNODELIST r;
	r.clear();

	vector<vector<XMLNODE>::iterator> parents;
	parents.clear();

	vector<XMLNODE>::iterator cur;
	vector<XMLNODE> * dd;
	dd=NULL;
	while (1)
	{
		if (dd==NULL)
		{
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur=dd->begin();
		}
		while (!cur->childs.empty())
		{
			if (cur->type==XN_ELEMENT && cur->tag==tag)
				r.push_back(cur);
			parents.push_back(cur);
			dd=&cur->childs;
			cur=cur->childs.begin();
		}
		if (cur->type==XN_ELEMENT && cur->tag==tag)
			r.push_back(cur);
		cur++;
		while (cur==dd->end() && !parents.empty())
		{
			cur=*parents.rbegin();
			parents.pop_back();
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur++;
		}
		if (cur==dd->end() && parents.empty())
			break;
	}

	return r;
}

XMLCONSTNODELIST xml_enum_elements(const XMLDOC & doc, const wstring & tag)
{
	XMLCONSTNODELIST r;
	r.clear();

	vector<vector<XMLNODE>::const_iterator> parents;
	parents.clear();

	vector<XMLNODE>::const_iterator cur;
	const vector<XMLNODE> * dd;
	dd=NULL;
	while (1)
	{
		if (dd==NULL)
		{
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur=dd->begin();
		}
		while (!cur->childs.empty())
		{
			if (cur->type==XN_ELEMENT && cur->tag==tag)
				r.push_back(cur);
			parents.push_back(cur);
			dd=&cur->childs;
			cur=cur->childs.begin();
		}
		if (cur->type==XN_ELEMENT && cur->tag==tag)
			r.push_back(cur);
		cur++;
		while (cur==dd->end() && !parents.empty())
		{
			cur=*parents.rbegin();
			parents.pop_back();
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur++;
		}
		if (cur==dd->end() && parents.empty())
			break;
	}

	return r;
}

XMLNODELIST xml_enum_pi(XMLDOC & doc, const wstring & tag)
{
	XMLNODELIST r;
	r.clear();

	vector<vector<XMLNODE>::iterator> parents;
	parents.clear();

	vector<XMLNODE>::iterator cur;
	vector<XMLNODE> * dd;
	dd=NULL;
	while (1)
	{
		if (dd==NULL)
		{
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur=dd->begin();
		}
		while (!cur->childs.empty())
		{
			parents.push_back(cur);
			dd=&cur->childs;
			cur=cur->childs.begin();
		}
		if (cur->type==XN_PROCESS_INST && cur->tag==tag)
			r.push_back(cur);
		cur++;
		while (cur==dd->end() && !parents.empty())
		{
			cur=*parents.rbegin();
			parents.pop_back();
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur++;
		}
		if (cur==dd->end() && parents.empty())
			break;
	}

	return r;
}

XMLCONSTNODELIST xml_enum_pi(const XMLDOC & doc, const wstring & tag)
{
	XMLCONSTNODELIST r;
	r.clear();

	vector<vector<XMLNODE>::const_iterator> parents;
	parents.clear();

	vector<XMLNODE>::const_iterator cur;
	const vector<XMLNODE> * dd;
	dd=NULL;
	while (1)
	{
		if (dd==NULL)
		{
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur=dd->begin();
		}
		while (!cur->childs.empty())
		{
			parents.push_back(cur);
			dd=&cur->childs;
			cur=cur->childs.begin();
		}
		if (cur->type==XN_PROCESS_INST && cur->tag==tag)
			r.push_back(cur);
		cur++;
		while (cur==dd->end() && !parents.empty())
		{
			cur=*parents.rbegin();
			parents.pop_back();
			if (parents.empty())
				dd=&doc;
			else
				dd=&(*parents.rbegin())->childs;
			cur++;
		}
		if (cur==dd->end() && parents.empty())
			break;
	}

	return r;
}

wstring xml_get_text(const XMLNODE & node)
{
	wstring r;
	xml_get_text(node,r);
	return r;
}

void xml_get_text(const XMLNODE & node, wstring & r)
{
	r.clear();
	switch(node.type)
	{
	case XN_TEXT:
	case XN_CDATA:
	case XN_DOCTYPE:
		r+=node.data;
		break;
	case XN_COMMENT:
	case XN_PROCESS_INST:
		break;
	case XN_ELEMENT:
		{
			size_t i;
			size_t xnum;
			xnum=node.childs.size();
			for(i=0;i<xnum;i++)
			{
				const XMLNODE & c=node.childs[i];
				switch(c.type)
				{
				case XN_TEXT:
				case XN_CDATA:
					r+=c.data;
					break;
				case XN_ELEMENT:
					{
						wstring xx;
						xml_get_text(node,xx);
						r+=xx;
					}
					break;
				}
			}
		}
		break;
	}
}

void xml_set_text(XMLNODE & node, const wstring & text)
{
	node.childs.clear();
	switch(node.type)
	{
	case XN_TEXT:
	case XN_CDATA:
	case XN_DOCTYPE:
	case XN_COMMENT:
		node.data=text;
		break;
	case XN_PROCESS_INST:
		break;
	case XN_ELEMENT:
		{
			XMLNODE xx;
			xx.type=XN_TEXT;
			xx.tag.clear();
			xx.data=text;
			xx.attrs.clear();
			xx.childs.clear();
			xml_add_node(node,xx);
		}
		break;
	}
	return ;
}

void xml_add_node(XMLNODE & node, const XMLNODE & child)
{
	if (node.type!=XN_ELEMENT)
		return;
	node.childs.push_back(child);
}

void xml_insert_node(XMLNODE & node, const XMLNODE & before, const XMLNODE & child)
{
	if (node.type!=XN_ELEMENT)
		return;
	size_t i;
	size_t xn;
	xn=node.childs.size();
	for(i=0;i<xn;i++)
	{
		if (&node.childs[i]==&before)
			break;
	}
	node.childs.insert(node.childs.begin()+i,child);
}

void xml_remove_node(XMLNODE & node, const XMLNODE & child)
{
	if (node.type!=XN_ELEMENT)
		return;
	size_t i;
	size_t xn;
	xn=node.childs.size();
	for(i=0;i<xn;i++)
	{
		if (&node.childs[i]==&child)
			break;
	}
	if (i<xn)
		node.childs.erase(node.childs.begin()+i);
}

void xml_get_attrs(const XMLNODE & node, vector<XMLATTR> & attrs)
{
	if (node.type==XN_ELEMENT
		||node.type==XN_PROCESS_INST)
		attrs=node.attrs;
	else
		attrs.clear();
}

wstring xml_get_attr(const XMLNODE & node, const wstring & attr)
{
	wstring r;
	xml_get_attr(node,attr,r);
	return r;
}

void xml_get_attr(const XMLNODE & node, const wstring & attr, wstring & r)
{
	r.clear();
	if (node.type!=XN_ELEMENT
		&& node.type!=XN_PROCESS_INST)
		return;
	size_t i;
	size_t alen=node.attrs.size();
	for(i=0;i<alen;i++)
		if (node.attrs[i].name==attr)
			break;
	if (i>=alen)
		return;
	r=node.attrs[i].value;
	return;
}

void xml_set_attr(XMLNODE & node, const wstring & attr, const wstring & value)
{
	if (node.type!=XN_ELEMENT
		&& node.type!=XN_PROCESS_INST)
		return;
	size_t i;
	size_t alen=node.attrs.size();
	for(i=0;i<alen;i++)
		if (node.attrs[i].name==attr)
			break;
	if (i>=alen)
		node.attrs.push_back(XMLATTR(attr,value));
	else
		node.attrs[i].value=value;
}

void xml_remove_attr(XMLNODE & node, const wstring & attr)
{
	if (node.type!=XN_ELEMENT
		&& node.type!=XN_PROCESS_INST)
		return;
	size_t i;
	size_t alen=node.attrs.size();
	for(i=0;i<alen;i++)
		if (node.attrs[i].name==attr)
			break;
	if (i<alen)
		node.attrs.erase(node.attrs.begin()+i);
}
