#ifndef _XMLFUNC_H
#define _XMLFUNC_H

#pragma once

#include <string>
#include <cstring>
#include <fstream>
#include <vector>
#include <map>
#include <wchar.h>

using namespace std;

#ifdef _UNICODE

#ifndef _TCHAR_DEFINED
#define _TCHAR_DEFINED

// basic
#define TCHAR wchar_t
#define _T(x) L ## x

// io
#define _tprintf wprintf
#define _ftprintf fwprintf
#define _stprintf swprintf
#define _vtprintf   vwprintf
#define _vftprintf  vfwprintf
#define _vstprintf  vswprintf
#define _tscanf wscanf
#define _ftscanf fwscanf
#define _fgettc fgetwc
#define _fgetts fgetws
#define _fputtc fputwc
#define _fputts fputws
#define _gettc      getwc
#define _gettchar   getwchar
#if  defined(_WIN32) || defined(_WIN64)
#define _getts      _getws
#else
#define _getts      getws
#endif
#define _puttc      putwc
#define _puttchar   putwchar
#if  defined(_WIN32) || defined(_WIN64)
#define _putts      _putws
#else
#define _putts      putws
#endif
#define _ungettc    ungetwc

// convert
#define _tcstol wcstol
#define _tcstod     wcstod
#define _tcstoul    wcstoul
#if  defined(_WIN32) || defined(_WIN64)
#define _tcstoll    _wcstoi64
#define _tcstoull   _wcstoui64 
#else
#define _tcstoll	wcstoll
#define _tcstoll	wcstoull
#endif

// string
#define _tcscat     wcscat
#define _tcschr     wcschr
#define _tcscpy     wcscpy
#define _tcscspn    wcscspn
#define _tcslen     wcslen
#define _tcsncat    wcsncat
#define _tcsncpy    wcsncpy
#define _tcspbrk    wcspbrk
#define _tcsrchr    wcsrchr
#define _tcsspn     wcsspn
#define _tcsstr     wcsstr
#define _tcstok     wcstok

#define _tcscmp     wcscmp
#define _tcsncmp    wcsncmp
#define _tcscoll    wcscoll

#if  defined(_WIN32) || defined(_WIN64)
#define _tcsdup     _wcsdup
#define _tcsicmp    _wcsicmp
#define _tcsnicmp   _wcsnicmp
#else
#define _tcsdup     wcsdup
#define _tcsicmp    wcscasecmp
#define _tcsnicmp   wcsncasecmp
#endif

// time
#define _tcsftime   wcsftime

// ctype
#define _istalnum   iswalnum
#define _istalpha   iswalpha
#define _istascii   iswascii
#define _istcntrl   iswcntrl
#define _istdigit   iswdigit
#define _istgraph   iswgraph
#define _istlower   iswlower
#define _istprint   iswprint
#define _istpunct   iswpunct
#define _istspace   iswspace
#define _istupper   iswupper
#define _istxdigit  iswxdigit

#define _totupper   towupper
#define _totlower   towlower

// program
#define _tmain wmain
#endif // _TCHAR_DEFINED

#define tstring wstring

#define w2t(x) tstring(x)
#define t2w(x) wstring(x)
#define t2c(x) w2c(x)
#define c2t(x) c2w(x)
#define u2t(x) u2w(x)
#define t2u(x) w2u(x)

#else // _UNICODE

#ifndef _TCHAR_DEFINED
#define _TCHAR_DEFINED
// basic
#define TCHAR char
#define _T(x) x

// io
#define _tprintf printf
#define _ftprintf fprintf
#define _stprintf sprintf
#define _vtprintf   vprintf
#define _vftprintf  vfprintf
#define _vstprintf  vsprintf
#define _tscanf scanf
#define _ftscanf fscanf
#define _fgettc fgetc
#define _fgetts fgets
#define _fputtc fputc
#define _fputts fputs
#define _gettc      getc
#define _gettchar   getchar
#define _getts      gets
#define _puttc      putc
#define _puttchar   putchar
#define _putts      puts
#define _ungettc    ungetc

// convert
#define _tcstol strtol
#define _tcstod     strtod
#define _tcstoul    strtoul
#if  defined(_WIN32) || defined(_WIN64)
#define _tcstoll    strtoi64
#define _tcstoull   strtoui64 
#else
#define _tcstoll	strtoll
#define _tcstoull	strtoull
#endif

// string
#define _tcscat     strcat
#define _tcschr     strchr
#define _tcscpy     strcpy
#define _tcscspn    strcspn
#define _tcslen     strlen
#define _tcsncat    strncat
#define _tcsncpy    strncpy
#define _tcspbrk    strpbrk
#define _tcsrchr    strrchr
#define _tcsspn     strspn
#define _tcsstr     strstr
#define _tcstok     strtok
#define _tcsdup     strdup

#define _tcscmp     strcmp
#define _tcsncmp    strncmp
#define _tcscoll    strcoll

#if  defined(_WIN32) || defined(_WIN64)
#define _tcsicmp    stricmp
#define _tcsnicmp   strnicmp
#else
#define _tcsicmp    strcasecmp
#define _tcsnicmp   strncasecmp
#endif

// time
#define _tcsftime   strftime

// ctype
#define _istalnum   isalnum
#define _istalpha   isalpha
#define _istascii   isascii
#define _istcntrl   iscntrl
#define _istdigit   isdigit
#define _istgraph   isgraph
#define _istlower   islower
#define _istprint   isprint
#define _istpunct   ispunct
#define _istspace   isspace
#define _istupper   isupper
#define _istxdigit  isxdigit

#define _totupper   toupper
#define _totlower   tolower

// program
#define _tmain main
#endif // _TCHAR_DEFINED

#define tstring string

#define w2t(x) w2c(x)
#define t2w(x) c2w(x)
#define t2c(x) string(x)
#define c2t(x) tstring(x)
#define t2u(x) c2u(x)
#define u2t(x) u2c(x)

#endif // _UNICODE

typedef string XMLENC;
typedef const XMLENC & XMLENCREF;

#ifndef _WIN32
#define wcsicmp wcscasecmp
#define stricmp strcasecmp
#endif

inline int operator == (XMLENCREF x, const char * y)
{
	return stricmp(x.c_str(),y)==0;
}

#define EC_ERROR XMLENC("_ERROR_")
#define EC_AUTO XMLENC("_AUTO_")
#define EC_DETECT EC_AUTO
#define EC_DEFAULT XMLENC("")
#define EC_NONE EC_DEFAULT
#define EC_UTF8 XMLENC("UTF-8")
#define EC_UTF16LE XMLENC("UTF-16LE")
#define EC_UTF16BE XMLENC("UTF-16BE")
#define EC_UNICODE EC_UTF16LE
#define EC_UTF16 EC_UTF16LE
#define EC_UCS2 EC_UTF16LE // UCS-2
#define EC_UTF32LE XMLENC("UTF-32LE")
#define EC_UTF32BE XMLENC("UTF-32BE")
#define EC_UTF32 EC_UTF32LE
#define EC_UCS4 EC_UTF32LE // UCS-4
#define EC_UTF7 XMLENC("UTF-7")

#define EC_ASCII XMLENC("iso-8859-1")
#define EC_RUS_ISO XMLENC("iso-8859-5")
#define EC_RUS_WIN XMLENC("windows-1251")
#define EC_RUS_KOI8R XMLENC("koi8-r")
#define EC_GREEK XMLENC("iso-8859-7")
#define EC_GB XMLENC("gbk")  // GBK
#define EC_GBK EC_GB
#define EC_GB2312 EC_GB
#define EC_CN EC_GB
#define EC_BIG5 XMLENC("big5") // BIG5
#define EC_TW EC_BIG5
#define EC_SJIS XMLENC("shift-jis") // SHIFT-JIS
#define EC_EUCJP XMLENC("euc-jp") // EUC-JP
#define EC_EUCKR XMLENC("euc-kr") // EUC-KR

enum {
	XN_TEXT,
	XN_ELEMENT,
	XN_CDATA,
	XN_DOCTYPE,
	XN_PROCESS_INST,
	XN_COMMENT,
};

struct XMLATTR {
	wstring name;
	wstring value;
	XMLATTR(const wstring & n=L"", const wstring & v=L"")
		:name(n),value(v)
	{}
};

struct XMLNODE {
	int type;
	wstring tag;
	wstring data;
	vector<XMLATTR> attrs;
	vector<XMLNODE> childs;
};

typedef vector<XMLNODE> XMLDOC;
typedef vector<vector<XMLNODE>::iterator> XMLNODELIST;
typedef vector<vector<XMLNODE>::const_iterator> XMLCONSTNODELIST;

XMLENC xml_load(const TCHAR * fn, XMLDOC & doc);
int xml_load_str(const wstring & str, XMLDOC & doc);
size_t xml_save(const TCHAR * fn, const XMLDOC & doc, XMLENCREF encoding=EC_DEFAULT);
wstring xml_save_str(const XMLDOC & doc);
void xml_save_str(wstring & str, const XMLDOC & doc);
void xml_display(ostream & os, const XMLDOC & doc);
XMLCONSTNODELIST xml_enum_elements(const XMLDOC & doc, const wstring & tag);
XMLNODELIST xml_enum_elements(XMLDOC & doc, const wstring & tag);
XMLNODELIST xml_enum_elements(XMLNODE & doc, const wstring & tag);
XMLCONSTNODELIST xml_enum_elements(const XMLNODE & doc, const wstring & tag);
XMLCONSTNODELIST xml_enum_pi(const XMLDOC & doc, const wstring & tag);
XMLNODELIST xml_enum_pi(XMLDOC & doc, const wstring & tag);
wstring xml_get_text(const XMLNODE & node);
void xml_get_text(const XMLNODE & node, wstring & r);
void xml_set_text(XMLNODE & node, const wstring & text);
void xml_add_node(XMLNODE & node, const XMLNODE & child);
void xml_insert_node(XMLNODE & node, const XMLNODE & before, const XMLNODE & child);
void xml_remove_node(XMLNODE & node, const XMLNODE & child);
void xml_get_attrs(const XMLNODE & node, vector<XMLATTR> & attrs);
wstring xml_get_attr(const XMLNODE & node, const wstring & attr);
void xml_get_attr(const XMLNODE & node, const wstring & attr, wstring & r);
void xml_set_attr(XMLNODE & node, const wstring & attr, const wstring & value=L"");
void xml_remove_attr(XMLNODE & node, const wstring & attr);

string w2c(const wstring & s);
void w2c(string & r, const wstring & s);
wstring c2w(const string & s);
void c2w(wstring & r, const string & s);

string u2c(const string & s);
void u2c(string & r, const string & s);
string c2u(const string & str);
void c2u(string & r, const string & str);

wstring loctow(const string & s, XMLENCREF loc);
void loctow(wstring & r, const string & s, XMLENCREF loc);
string wtoloc(const wstring & s, XMLENCREF loc);
void wtoloc(string & r, const wstring & s, XMLENCREF loc);

string loctou(const string & str, XMLENCREF loc);
void loctou(string & r, const string & str, XMLENCREF loc);
string utoloc(const string & str, XMLENCREF loc);
void utoloc(string & r, const string & str, XMLENCREF loc);

wstring u2w(const string & s);
void u2w(wstring & r, const string & s);
string w2u(const wstring & str);
void w2u(string & r, const wstring & str);

wstring u7tow(const string & s);
void u7tow(wstring & r, const string & s);
string wtou7(const wstring & str);
void wtou7(string & r, const wstring & str);

string u7tou(const string & str);
void u7tou(string & r, const string & str);
string utou7(const string & str);
void utou7(string & r, const string & str);

XMLENC detect_ec(unsigned char * x);

XMLENC readtextfile(const TCHAR * fn, wstring & data, XMLENCREF encoding=EC_AUTO, int isxml=0);
size_t writetextfile(const TCHAR * fn, const wstring & str, XMLENCREF encoding=EC_DEFAULT);

XMLENC readtextfile(const TCHAR * fn, string & data, XMLENCREF encoding=EC_AUTO, int isxml=0);
size_t writetextfile(const TCHAR * fn, const string & str, XMLENCREF encoding=EC_DEFAULT);

wstring extract_tag_attribute(const wstring & name, const wstring & data);
void extract_tag_attribute(wstring & attr, const wstring & name, const wstring & data);
int extract_tag_and_span(const wstring & name, wstring &data, wstring &tag, wstring &span);
wstring combine_tag(const wstring & tag, const map<wstring,wstring> & attr, const wstring & data);
void combine_tag(wstring & r, const wstring & tag, const map<wstring,wstring> & attr, const wstring & data);

string extract_tag_attribute(const string & name, const string & data);
void extract_tag_attribute(string & attr, const string & name, const string & data);
int extract_tag_and_span(const string & name, string &data, string &tag, string &span);
string combine_tag(const string & tag, const map<string,string> & attr, const string & data);
void combine_tag(string & r, const string & tag, const map<string,string> & attr, const string & data);

wstring extract_line(wstring & data);
void extract_line(wstring & r, wstring & data);
int extract_char(wstring & data);
// get wide char at data[r] and move r to next char
int get_char(const wstring & data, size_t & r);

string extract_line(string & data);
void extract_line(string & r, string & data);
int extract_char(string & data);
// get wide char at data[r] and move r to next char
int get_char(const string & data, size_t & r);

wstring trimall(const wstring & str);
void trimall(wstring & r, const wstring & str);
wstring ltrim(const wstring & str);
void ltrim(wstring & r, const wstring & str);
wstring rtrim(const wstring & str);
void rtrim(wstring & r, const wstring & str);

string trimall(const string & str);
void trimall(string & r, const string & str);
string ltrim(const string & str);
void ltrim(string & r, const string & str);
string rtrim(const string & str);
void rtrim(string & r, const string & str);

wstring replace_ref(const wstring & str);
void replace_ref(wstring & r, const wstring & str);
wstring remove_ref(const wstring & str);
void remove_ref(wstring & r, const wstring & str);

string replace_ref(const string & str);
void replace_ref(string & r, const string & str);
string remove_ref(const string & str);
void remove_ref(string & r, const string & str);

XMLENC text_getbom(ifstream & fp, XMLENCREF encoding);
wint_t text_getc(ifstream & fp, XMLENCREF encoding);
wstring text_gets(ifstream & fp, XMLENCREF encoding);
void text_gets(wstring & r, ifstream & fp, XMLENCREF encoding);
size_t text_putbom(ofstream & fp, XMLENCREF encoding);
size_t text_putc(wint_t c, ofstream & fp, XMLENCREF encoding);
size_t text_puts(const wstring & s, ofstream & fp, XMLENCREF encoding);

#endif // _XMLFUNC
