import argparse
import os

parser = argparse.ArgumentParser()
parser.add_argument('--input_file', required = True, help = 'bpe file')
parser.add_argument('--nbest_log', required = True, help = 'nbest.log file')
parser.add_argument('--mode', required = True)
parser.add_argument('--final_input', required = True, help = 'input')
parser.add_argument('--final_output', required = True, help = 'output')
args = parser.parse_args()

input_file = args.input_file
nbest_log = args.nbest_log
final_input = args.final_input
final_output = args.final_output
mode = args.mode

input_file = open(input_file,'r',encoding='utf-8')
nbest_log = open(nbest_log,'r',encoding='utf-8')
final_input = open(final_input,'w',encoding='utf-8')
final_output = open(final_output,'w',encoding='utf-8')

split_string = '=================================='

def reverse_string(str):
  str_list= str.split()
  str_list.reverse()
  final_sten = ''
  for s in str_list:
    final_sten += s+' '
  final_sten = final_sten.strip()
  return final_sten

def change_string(input, output, mode='LS-LT'):
  if mode == 'LS-LT':
    return input, output
  elif mode == 'LS-RT':
    return input, reverse_string(output)
  elif mode == 'LT-LS':
    return output, input
  elif mode == 'LT-RS':
    return output, reverse_string(input)
  elif mode == 'RS-LT':
    return reverse_string(input), output
  elif mode == 'RS-RT':
    return reverse_string(input), reverse_string(output)
  elif mode == 'RT-LS':
    return reverse_string(output), input
  elif mode == 'RT-RS':
    return reverse_string(output), reverse_string(input)

if __name__ == '__main__':
    input_line = input_file.readline().strip()
    while 1:
        line = nbest_log.readline().strip()
        if not line:
            break
        if line == split_string:
            input_line = input_file.readline().strip()
            final_input.write(split_string + '\n')
            final_output.write(split_string + '\n')
        else:
            info = line.split('||||')
            sten = info[0].strip()
            input_line1, sten1 = change_string(input_line, sten, mode)
            final_input.write(input_line1 + '\n')
            final_output.write(sten1+'\n')
    input_file.close()
    nbest_log.close()
    final_input.close()
    final_output.close()
