/* NiuTrans.Tensor - an open-source tensor library
 * Copyright (C) 2018, Natural Language Processing Lab, Northestern University.
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * backward computation for data operation
 * $Created by: Xu Chen (email: hello_master1954@163.com) 2018-12-26
 */

#include "../tensor/XTensor.h"
#include "../tensor/function/FHeader.h"

#ifndef __XBACKWARDDATA_H__
#define __XBACKWARDDATA_H__

namespace nts{

/* this class computes the gradient for tensor data operation given a node */
class XDataGrad
{
public:
    /* compute dE/dx of a node */
    static
    void MakeGrad(XTensor * node, bool isEfficent);

    /* indicates whether the node is for a shaping operation */
    static
    bool IsDataOP(XTensor * node);

private:
    
    /* gradient computation for ConverDataType: b = converdatatype(a, datatype) */
    static
    void GradConvertDataType(XTensor * node, bool isEfficent);

    /* gradient computation for IndexToOnehot: b = indextoonehot(a, num) */
    static
    void GradIndexToOnehot(XTensor * node, bool isEfficent);

    /* gradient computation for OnehotToIndex: b = onehottoindex(a, num) */
    static
    void GradOnehotToIndex(XTensor * node, bool isEfficent);
};

} // namespace nts(NiuTrans.Tensor)

#endif