/* NiuTrans.Tensor - an open-source tensor library
 * Copyright (C) 2018, Natural Language Processing Lab, Northestern University. 
 * All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * $Created by: XIAO Tong (xiaotong@mail.neu.edu.cn) 2018-07-31
 */

#include "Transformer.h"
#include "T2TModel.h"
#include "T2TUtility.h"
#include "T2TTrainer.h"
#include "../../tensor/XDevice.h"

namespace transformer
{

int TransformerMain(int argc, const char ** argv)
{
    if(argc == 0)
        return 1;

    tmpFILE = fopen("tmp.txt", "wb");

    ShowParams(argc, argv);

    char * trainFN = new char[MAX_LINE_LENGTH];

    LoadParamString(argc, argv, "train", trainFN, "");

    T2TModel model;

    model.InitModel(argc, argv);

    if(strcmp(trainFN, "")){
        T2TTrainer trainer;
        trainer.Init(argc, argv);
        trainer.Train(trainFN, &model);
    }

    delete[] trainFN;

    fclose(tmpFILE);

    return 0;
}

}